/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file hazelnut_throwable_item.cpp
 * \brief Implementation of the ptb::hazelnut_throwable_item class.
 * \author Sebastien Angibaud
 */
#include "ptb/throwable_item/hazelnut_throwable_item.hpp"

#include "ptb/level_variables.hpp"
#include "ptb/player.hpp"
#include "ptb/item/hazelnut.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 * \param p The pointer on the player.
 */
ptb::hazelnut_throwable_item::hazelnut_throwable_item(player* p)
  : throwable_item(p)
{
} // hazelnut_throwable_item::hazelnut_throwable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the throwable_item.
 */
bear::engine::base_item*
ptb::hazelnut_throwable_item::create_throwable_item() const
{
  hazelnut* new_hazelnut = new hazelnut();

  /*
  bear::universe::force_type force(600000,600000);

  if ( m_player->get_rendering_attributes().is_mirrored() )
    force.x = -force.x;

  force.x = force.x + 2000*m_player->get_speed().x;
  force.y = force.y + 20*m_player->get_speed().y;

  new_hazelnut->add_external_force(force);
  */

  return new_hazelnut;
} // hazelnut_throwable_item::create_throwable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Decrease the stock.
 */
void ptb::hazelnut_throwable_item::decrease_stock() const
{
  level_variables::set_hazelnut(m_player->get_level(),false);
} // hazelnut::throwable_item::decrease_stock()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the stock.
 */
unsigned int ptb::hazelnut_throwable_item::get_stock() const
{
  if ( level_variables::get_hazelnut(m_player->get_level()) )
    return 1;
  else
    return 0;
} // hazelnut_throwable_item::get_stock()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the animation of the throwable_item.
 */
const bear::visual::animation&
ptb::hazelnut_throwable_item::get_animation() const
{
  bear::engine::level_globals& glob = m_player->get_level_globals();

  return glob.get_animation("animation/owl/hazelnut.canim");
} // hazelnut_throwable_item::get_animation()
