//
// SessionImpl.h
//
// $Id: //poco/1.3/Data/MySQL/include/Poco/Data/MySQL/SessionImpl.h#2 $
//
// Library: Data
// Package: MySQL
// Module:  SessionImpl
//
// Definition of the SessionImpl class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Data_MySQL_SessionImpl_INCLUDED
#define Data_MySQL_SessionImpl_INCLUDED


#include "Poco/Data/MySQL/MySQL.h"
#include "Poco/Data/AbstractSessionImpl.h"
#include "Poco/Data/MySQL/SessionHandle.h"


namespace Poco {
namespace Data {
namespace MySQL {


class MySQL_API SessionImpl: public Poco::Data::AbstractSessionImpl<SessionImpl>
	/// Implements SessionImpl interface
{
public:
	SessionImpl(const std::string& connectionString);
		/// Creates the SessionImpl. Opens a connection to the database
		///
		/// Connection string format:
		///     <str> == <assignment> | <assignment> ';' <str>
		///     <assignment> == <name> '=' <value>
		///     <name> == 'host' | 'port' | 'user' | 'password' | 'db' } 'compress' | 'auto-reconnect'
		///     <value> == [~;]*
		///
		/// for compress and auto-reconnect correct values are true/false
		/// for port - numeric in decimal notation
		///
		
	~SessionImpl();
		/// Destroys the SessionImpl.
		
	virtual Poco::Data::StatementImpl* createStatementImpl();
		/// Returns an MySQL StatementImpl

	virtual void begin();
		/// Starts a transaction
	
	virtual void commit();
		/// Commits and ends a transaction		

	virtual void rollback();
		/// Aborts a transaction
		
	virtual void close();
		/// Closes the connection
		
	virtual bool isConnected();
		/// Returns true iff session is connected.
		
	virtual bool isTransaction();
		/// Returns true iff a transaction is in progress.
		
	void setInsertId(const std::string&, const Poco::Any&);
		/// Try to set insert id - do nothing.
		
	Poco::Any getInsertId(const std::string&);
		/// Get insert id

private:
	SessionHandle _mysql;
	bool          _connected;
	int           _inTransaction;
};


//
// inlines
//
inline void SessionImpl::setInsertId(const std::string&, const Poco::Any&)
{
}


inline Poco::Any SessionImpl::getInsertId(const std::string&)
{
	return Poco::Any(Poco::UInt64(mysql_insert_id(_mysql)));
}


} } } // namespace Poco::Data::MySQL


#endif // Data_MySQL_SessionImpl_INCLUDED
