
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#include "base/polygraph.h"

#include "xstd/Rnd.h"
#include "xstd/rndDistrs.h"
#include "xstd/StrIdentifier.h"
#include "xstd/h/iomanip.h"
#include "base/RndPermut.h"
#include "pgl/AgentSym.h"
#include "runtime/SslWraps.h"
#include "runtime/Agent.h"
#include "runtime/AgentCfg.h"
#include "runtime/LogComment.h"


AgentCfg::AgentCfg(): theSslWrapSel(0), theHttpVersionSel(0),
	theCookieSenderProb(0) {
}

AgentCfg::~AgentCfg() {
	delete theSslWrapSel;
	delete theHttpVersionSel;
}

void AgentCfg::configure(const AgentSym *agent) {
	Assert(agent);

	configureSslWraps(agent);
	configureHttpVersions(agent);
}

void AgentCfg::configureSslWraps(const AgentSym *agent) {
	Array<SslWrapSym*> syms;
	if (!agent->sslWraps(syms, theSslWrapSel))
		return; // no SSL wrappers configured

	TheSslWraps.get(syms, theSslWraps);
	theSslWrapSel->rndGen(GlbRndGen("ssl_wrappers"));
}

bool AgentCfg::selectSslWrap(const SslWrap *&wrap) {
	if (!theSslWraps.count())
		return false;

	const int wrapIdx = (int)theSslWrapSel->trial();
	if (!Should(0 <= wrapIdx && wrapIdx < theSslWraps.count()))
		return false;

	wrap = theSslWraps[wrapIdx];
	return true;
}

bool AgentCfg::selectCookieSenderStatus() {
	static RndGen rng;
	return rng.event(theCookieSenderProb);
}

void AgentCfg::configureHttpVersions(const AgentSym *agent) {
	static StrIdentifier sidf;
	if (!sidf.count()) {
		sidf.add("1.0", Agent::protoHttp1p0);
		sidf.add("1.1", Agent::protoHttp1p1);
		sidf.optimize();
	}

	theHttpVersionSel = agent->httpVersions(sidf);
	if (!theHttpVersionSel)
		theHttpVersionSel = new ConstDistr(0, Agent::protoHttp1p1); // default
	theHttpVersionSel->rndGen(LclRndGen("http_versions"));
}

int AgentCfg::selectHttpVersion() {
	return (int)theHttpVersionSel->trial();
}

