/*
CCLIENT.h
*/

#ifndef __myCCLIENT_H
#define __myCCLIENT_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#include <c-client.h>

#include "NewsRC.h"
#include "Language.h"
#include "Utils.h"
#include "Config.h"
#include "XString.h"
#include "XVector.h"
#include "Codecs.h"

typedef XVector<XString> StringList;

extern "C" void sort_thread_callback (MAILSTREAM *stream, THREADNODE *tree);
extern "C" long *sort_thread (THREADNODE *node, long *entry, long depth);
extern "C" long doTCPTimeout (long elapsed, long sincelast);
extern "C" void mm_flags (MAILSTREAM *stream,xulong number);
extern "C" void mm_status (MAILSTREAM *stream,char *mailbox,MAILSTATUS *status);
extern "C" void mm_list (MAILSTREAM *stream,int delim,char *name,long attrib);
extern "C" void mm_notify (MAILSTREAM *stream,char *string,long errflg);
extern "C" void mm_log (char *string,long errflg);
extern "C" void mm_dlog (char *string);
extern "C" void mm_login (NETMBX *mb,char *user,char *pwd,long trial);
extern "C" long mm_diskerror (MAILSTREAM *stream,long errcode,long serious);
extern "C" void mm_critical (MAILSTREAM *stream);
extern "C" void mm_nocritical (MAILSTREAM *stream);
extern "C" void mm_searched (MAILSTREAM *stream,xulong number);
extern "C" void mm_exists (MAILSTREAM *stream,xulong number);
extern "C" void mm_expunged (MAILSTREAM *stream,xulong number);
extern "C" void mm_lsub (MAILSTREAM *stream,int delim,char *name,long attrib);
extern "C" void mm_fatal (char *string);

extern "C" void mail_fetchfrom_mod (char *s,MAILSTREAM *stream,unsigned long msgno, long length, int option);
extern "C" void mail_fetchto_mod (char *s,MAILSTREAM *stream,unsigned long msgno, long length, int option);

#define NNTPFOLDERPREFIX "#"
#define NNTPFOLDERHTMLPREFIX HTML_SOSTENIDO

enum TServerProtocol {PROTOCOL_IMAP, PROTOCOL_NNTP}; 

class CCLIENT
  {
  private:
    TServerProtocol ServerProtocol;
    bool TheDEBUG, TheERROR, SortReversed;
    MAILSTREAM *imapstream, *nntpstream;
    TFileName username, password, mailbox, fullmailbox;
    IPNAME imapserver, nntpserver;
    StringList *SLMailboxes, *SLSearch;
    ULongList *ILSort;
    XString XSearch;
    TBuffer MailboxPrefix, PathToRemoteFolder, FTo, FNewsgroups, FReplyTo, FFrom, FCC, FContentType, FSubject, 
            FDate, NETNEWSRC, FMessageId, FContentDisposition;
    TSBuffer ERRORSTRING, WARNINGSTRING;
    int imapport, nntpport, timeout, maxlogintrials, msgsmarkeddeleted, SortType, SortType2;
    char delimiter;
    long MAXMSGSFORPAGE, MAILBOXSIZE, TOTALMSGS;
    void display_body (BODY *body, char *pfx, long i, StringList *SLAttachs);
    char *getBriefMailbox (const char *amailbox, TBuffer abuf);    
    void doMailboxSize (void);
    MAILSTREAM *getStream (void);
    MAILSTREAM *getIMAPStream (void);
    MAILSTREAM *getNNTPStream (void);
    void setStream (MAILSTREAM *TheStream);    
  public:
    CCLIENT ();
    virtual ~CCLIENT ();
    bool isDebug (void);
    TServerProtocol getServerProtocol (void);
    void setServerProtocol (TServerProtocol aServerProtocol);
    void setMAXMSGSFORPAGE (long maxmsgs);
    char *getFullMailbox (char *amailbox, TBuffer resbuf);    
    xulong getNumMsgFromPosList (xulong pos);
    xulong getPosListFromNumMsg (xulong nummsg);
    bool isLastMsgFromList (xulong nummsg);
    char *getUsername (void);
    char *getPassword (void);
    bool Authenticate (const char *ahost, int aport, const char *amailbox, const char *ausername, const char *apassword);
    bool Reconnect (void);
    bool ChangeMailbox (char *newmailbox, bool ALLOW_NNTP);
    void addMailbox (char *name);
    MAILSTREAM *xmail_open (MAILSTREAM *stream, const char *fullmailbox, long options);
    void xmail_close (MAILSTREAM *stream);
    void CloseMailbox (void);
    void Expunge (void);    
    long getTotalMsgs (void);
    void setNetNewsParms(void);
    void setNetNewsRC (void);
    const char *getNetNewsRC(void);
    void setPathToRemoteFolder (const char *aPathToRemoteFolder);
    char *getPathToRemoteFolder (void);    
    void setMailboxPrefix (const char *aMailboxPrefix);
    char *getMailboxPrefix (void);
    void setIMAPServer (const char *aIMAPServer);
    char *getIMAPServer (void);
    void setNNTPServer (const char *aNNTPServer);
    char *getNNTPServer (void);
    bool getError (void);    
    void setError (bool value);
    char *getErrorString (void);
    void setErrorString (char *sterr);
    long getRecentMsgs (void);
    long getMsgsUnreadIMAPINBOX (void);
    char *getMailboxName (void);
    char *getNNTPMailboxName (void);
    char *getFullMailboxName (void);
    void setTimeout (int atimeout);
    void disableRSH (void);
    void hideDotFiles (void);
    void setDelimiter (char adelim);
    char getDelimiter (void);
    void setMaxLoginTrials (int amaxlogintrials);
    bool Ping (void);
    char *getAttIdFromCID (xulong nummsg, char *cid, TBuffer connid);
    int getMsgsMarkedDeleted (void);
    long getMailboxSize (void);
    void getHeaderList (xulong abeginmsg, StringList *SL, char *user, const char *maildomain, const char *tolabel, const char *TrueEmail);    
    char *getAttHeaderPC (xulong nummsg, char *attid);    
    void getAttHeaderSL (xulong nummsg, char *attid, StringList *SL);    
    char *dumpFullMsg (xulong nummsg);
    void dumpMsg (xulong nummsg, StringList *SL);
    void dumpFullHeader (xulong nummsg, StringList *SL);
    void dumpFullBody (xulong nummsg, StringList *SL);
    const char *getTo (xulong nummsg);
    const char *getNewsGroup (xulong nummsg);    
    const char *getCC (xulong nummsg);
    const char *getReplyTo (xulong nummsg);
    const char *getFrom (xulong nummsg);
    const char *getContentType (xulong nummsg);    
    const char *getSubject (xulong nummsg);
    const char *getContentDisposition (xulong nummsg);
    const char *getDate (xulong nummsg);
    const char *getMessageId (xulong nummsg);    
    char *getFlags (xulong nummsg, TBuffer tmp);
    xulong getSize (xulong nummsg);
    char *getFormattedSize (xulong nummsg, TBuffer abuf);
    void getBodyStructure (xulong nummsg, StringList *SLAttach);
    char *getAttBody (xulong nummsg, char *attid, StringList *SLAttachInfo, xulong *len, bool decodificar);    
    xulong getAttSize (xulong nummsg, char *attid, StringList *SLAttachInfo);    
    bool getAttBodyToFile (xulong nummsg, char *attid, StringList *SLAttachInfo, xulong *len, char *fname, bool decodificar);    
    void getAttachInfo (BODY *body, char *oripfx, char *pfx, long i, StringList *SLAttach, StringList *SLFullHeader);
    int setFlags (char *flags, char *pcmessages);
    int clearFlags (char *flags, char *pcmessages);    
    void getMailboxes (StringList *SL, StringList *SLSubscribedGroups, bool refreshIMAPFolders, bool ALLOW_NNTP);
    bool createMailbox (char *mailboxname);
    bool deleteMailbox (char *mailboxname);
    bool emptyMailbox (char *mailboxname);
    bool renameMailbox (char *oldmailboxname, char *newmailboxname);
    int copyMessages (const char *mailboxname, char *pcmessages);
    int moveMessages (const char *mailboxname, char *pcmessages);
    bool appendMsg (char *mailbox, STRING *msg);
    int searchFolder2 (char *range, int token, char *whatsearch, char *from, char *fecha);
    void addResultToSearch (xulong msgnum);
    bool delMsgInSearchList (xulong msgnum);
    void addMsgInSearchList (xulong msgnum);
    bool IsSearched (xulong nummsg);
    xulong getNumFirstMsgInSearch (void);
    void setSortType (int aSortType);
    int Sort (void);
    void getMsgIndex (ULongList *IL);
    void sortMailboxes (StringList *SL);
    void PathTool (const char *mailbox, int *numseps, int *poslastsep);
    char *expandMailboxName (const char *mailbox, TBuffer SentMailBox);
    void saveFlagsRCNewsFile (void);
    int getIndent (xulong nummsg);
    void setWarningString (char *stwarn);
    const char *getWarningString (void);
    };
  
#endif  


