/******************************************************************************
* Copyright (C) 2008 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.20                                                         *
******************************************************************************/

#ifndef CMASTERDAOFACTORYSQLITE_H_
#define CMASTERDAOFACTORYSQLITE_H_

#include <sqlite3.h>
#include <string>

#include "../../../dao/factory/IMasterDAOFactory.h"

#include "../../../dao/IPfVersionDAO.h"
#include "../../../dao/IPfGamesDAO.h"
#include "../../../dao/IPfUsersDAO.h"

#include "../CPfVersionDAOSQLite.h"
#include "../CPfGamesDAOSQLite.h"
#include "../CPfUsersDAOSQLite.h"

class CMasterDAOFactorySQLite : public IMasterDAOFactory
{
public:
    CMasterDAOFactorySQLite(const std::string &filepath);
    virtual ~CMasterDAOFactorySQLite();

    virtual bool executeScript(const std::string &script);
    virtual bool executeScriptFile(const char *scriptFile);

    virtual bool beginTransaction();
    virtual bool commit();
    virtual bool rollback();

    virtual void save();

    virtual IPfVersionDAO* getIPfVersionDAO();
    virtual IPfGamesDAO* getIPfGamesDAO();
    virtual IPfUsersDAO* getIPfUsersDAO();


private:
    void copyFile(const std::string &origin, const std::string &destination);

private:
    sqlite3     *m_database;
    std::string m_filepath;
    std::string m_filepath_tmp;

    CPfVersionDAOSQLite *m_PfVersionDAOSQLite;
    CPfGamesDAOSQLite *m_PfGamesDAOSQLite;
    CPfUsersDAOSQLite *m_PfUsersDAOSQLite;

};
#endif /*CMASTERDAOFACTORYSQLITE_H_*/
