/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfRolesDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfRolesDAOSQLiteEntity::CPfRolesDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfRolesDAOSQLiteEntity::~CPfRolesDAOSQLiteEntity()
{
}

void CPfRolesDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfRolesDAOSQLiteEntity::deleteReg(CPfRoles *reg)
{
    std::string sql("DELETE FROM PF_ROLES WHERE X_ROLE=");
    sql += "'"+reg->getXRole_str()+"'";
    return exec(sql);
}

bool CPfRolesDAOSQLiteEntity::insertReg(CPfRoles *reg)
{
    std::string sql("INSERT INTO PF_ROLES (S_SHORT_NAME,X_FK_DEMARCATION,S_NAME) VALUES (");
    sql += (reg->getSShortName_str()=="")?"NULL":"'"+reg->getSShortName_str()+"'";
    sql += (reg->getXFkDemarcation_str()=="")?",NULL":",'"+reg->getXFkDemarcation_str()+"'";
    sql += (reg->getSName_str()=="")?",NULL":",'"+reg->getSName_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXRole(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfRolesDAOSQLiteEntity::updateReg(CPfRoles *reg)
{
    std::string sql("UPDATE PF_ROLES SET ");
    sql += (reg->getSShortName_str()=="")?" S_SHORT_NAME=NULL":" S_SHORT_NAME='"+reg->getSShortName_str()+"'";
    sql += (reg->getXRole_str()=="")?",X_ROLE=NULL":",X_ROLE='"+reg->getXRole_str()+"'";
    sql += (reg->getXFkDemarcation_str()=="")?",X_FK_DEMARCATION=NULL":",X_FK_DEMARCATION='"+reg->getXFkDemarcation_str()+"'";
    sql += (reg->getSName_str()=="")?",S_NAME=NULL":",S_NAME='"+reg->getSName_str()+"'";
    sql += " WHERE X_ROLE='"+reg->getXRole_str()+"'";
    return exec(sql);
}

void CPfRolesDAOSQLiteEntity::freeVector(std::vector<CPfRoles*>* vector )
{
    std::vector<CPfRoles*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfRoles* CPfRolesDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfRoles *destiny = new CPfRoles();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfRoles*> * CPfRolesDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfRoles*> *container = new std::vector<CPfRoles*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfRolesDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfRolesDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfRoles *destiny = (CPfRoles*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "S_SHORT_NAME")==0 ){
                destiny->setSShortName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_ROLE")==0 ){
                destiny->setXRole_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_DEMARCATION")==0 ){
                destiny->setXFkDemarcation_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_NAME")==0 ){
                destiny->setSName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfRolesDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfRoles*> *container = (std::vector<CPfRoles*> *)object;
        CPfRoles *destiny = new CPfRoles();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "S_SHORT_NAME")==0 ){
                destiny->setSShortName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_ROLE")==0 ){
                destiny->setXRole_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_DEMARCATION")==0 ){
                destiny->setXFkDemarcation_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_NAME")==0 ){
                destiny->setSName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

