/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfSeasonsDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfSeasonsDAOSQLiteEntity::CPfSeasonsDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfSeasonsDAOSQLiteEntity::~CPfSeasonsDAOSQLiteEntity()
{
}

void CPfSeasonsDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfSeasonsDAOSQLiteEntity::deleteReg(CPfSeasons *reg)
{
    std::string sql("DELETE FROM PF_SEASONS WHERE X_SEASON=");
    sql += "'"+reg->getXSeason_str()+"'";
    return exec(sql);
}

bool CPfSeasonsDAOSQLiteEntity::insertReg(CPfSeasons *reg)
{
    std::string sql("INSERT INTO PF_SEASONS (N_YEAR,S_SEASON) VALUES (");
    sql += (reg->getNYear_str()=="")?"NULL":"'"+reg->getNYear_str()+"'";
    sql += (reg->getSSeason_str()=="")?",NULL":",'"+reg->getSSeason_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXSeason(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfSeasonsDAOSQLiteEntity::updateReg(CPfSeasons *reg)
{
    std::string sql("UPDATE PF_SEASONS SET ");
    sql += (reg->getXSeason_str()=="")?" X_SEASON=NULL":" X_SEASON='"+reg->getXSeason_str()+"'";
    sql += (reg->getNYear_str()=="")?",N_YEAR=NULL":",N_YEAR='"+reg->getNYear_str()+"'";
    sql += (reg->getSSeason_str()=="")?",S_SEASON=NULL":",S_SEASON='"+reg->getSSeason_str()+"'";
    sql += " WHERE X_SEASON='"+reg->getXSeason_str()+"'";
    return exec(sql);
}

void CPfSeasonsDAOSQLiteEntity::freeVector(std::vector<CPfSeasons*>* vector )
{
    std::vector<CPfSeasons*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfSeasons* CPfSeasonsDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfSeasons *destiny = new CPfSeasons();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfSeasons*> * CPfSeasonsDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfSeasons*> *container = new std::vector<CPfSeasons*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfSeasonsDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfSeasonsDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfSeasons *destiny = (CPfSeasons*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_SEASON")==0 ){
                destiny->setXSeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "N_YEAR")==0 ){
                destiny->setNYear_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_SEASON")==0 ){
                destiny->setSSeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfSeasonsDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfSeasons*> *container = (std::vector<CPfSeasons*> *)object;
        CPfSeasons *destiny = new CPfSeasons();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_SEASON")==0 ){
                destiny->setXSeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "N_YEAR")==0 ){
                destiny->setNYear_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_SEASON")==0 ){
                destiny->setSSeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

