/*
    CommandQueryPanel.m

    Implementation of the CommandQueryPanel class for the ProjectManager
    application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "CommandQueryPanel.h"

#import <Foundation/NSString.h>

#import <AppKit/NSNibLoading.h>
#import <AppKit/NSApplication.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSPanel.h>

@implementation CommandQueryPanel

static CommandQueryPanel * shared = nil;

+ shared
{
  if (shared == nil)
    {
      shared = [self new];
    }

  return shared;
}

- init
{
  if ([super init])
    {
      [NSBundle loadNibNamed: @"CommandQueryPanel" owner: self];

      return self;
    }
  else
    {
      return nil;
    }
}

- (NSString *) runModal
{
  int code;

  [panel selectKeyViewFollowingView: okButton];

  code = [NSApp runModalForWindow: panel];
  [panel close];

  if (code == NSOKButton)
    return [command stringValue];
  else
    return nil;
}

- (void) ok: sender
{
  [NSApp stopModalWithCode: NSOKButton];
}

- (void) cancel: sender
{
  [NSApp stopModalWithCode: NSCancelButton];
}

@end
