/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_SQL_H
#define GUI_SQL_H

#include <qwidget.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qmap.h>

class GUI_SQL : public QFrame  {
    Q_OBJECT
public:
    GUI_SQL(QWidget *parent=0, const char *name=0);

    void notifyNewCustomQueries(QMap<QString,QString>);

    ~GUI_SQL();

public slots:
    void slot_setConnectionState(bool state);

private:
    QPushButton *button_search;
    QPushButton *button_save;
    QPushButton *button_reset;
    QPushButton *button_remove;
    QLineEdit *phrase;
    QComboBox *customQueries;
    QMap<QString,QString> customQueriesMap;

    bool existsStoredQuery(QString);

private slots:
    void slot_buttonSearch();
    void slot_buttonReset();
    void slot_buttonSave();
    void slot_buttonRemove();
    void slot_runCustomQuery(int);
};

#endif
