/***************************************************************************
                          lvi_nfsexport.cpp  -  description
                             -------------------
    begin                : Wed Feb 27 2002
    copyright            : (C) 2002 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_nfsexport.h"
#include "gui.h"
#include "pixmapcache.h"

LVI_NFSExport::LVI_NFSExport(QListView *parent, int _exportID, QString _path, QString _export)
: QListViewItem(parent), exportID(_exportID), path(_path), Export(_export) {
    device = Export;

    //  share.replace(0, 2, "");
    //  QString machine = export; machine.truncate(share.find("/"));
    //  QString sharename = share; sharename.replace(0, machine.length()+1, "");

    //  label = QString(machine.upper() + ": " + sharename.upper());
    QString machine = Export;
    machine.truncate(machine.find(":"));
    //    if(machine.contains('.')) machine.truncate(machine.find("."));
    QString path = Export.section(":", 1);
    label = QString(machine + ":" + path);
    isLocked = false;
    applyUnmount();
    applyInfo(-1);
}

void LVI_NFSExport::lock(QString comment) {
    isLocked = true;
    setText(0, label + " [" + comment + "...]");
}

void LVI_NFSExport::unlock() {
    isLocked = false;
    if(medium != -1)
        setText(0, label + " [DB]");
    else
        setText(0, label);
}

void LVI_NFSExport::applyMount() {
    isMounted = true;
    setPixmap(0, pixmapcache->get
              ("lvi_nfs.png"));
}

void LVI_NFSExport::applyUnmount() {
    isMounted = false;
    setPixmap(0, pixmapcache->getFaded("lvi_nfs.png"));
}

void LVI_NFSExport::applyInfo(int mediumid) {
    medium = mediumid;
    if(medium != -1)
        setText(0, label + " [DB]");
    else
        setText(0, label);
}
