#include "loader.h"

#include <QNetworkProxy>


Loader::Loader(QString id, QObject *p)
	: QObject(p)
	, id_(id)

{
	manager_ = new QNetworkAccessManager(this);
}

Loader::~Loader()
{
}

void Loader::setProxy(QString host, int port, QString user, QString pass)
{
	QNetworkProxy proxy(QNetworkProxy::HttpCachingProxy,host,port,user,pass);
	manager_->setProxy(proxy);
}

void Loader::start(const QString& url)
{	
	manager_->get(QNetworkRequest(QUrl(url)));
	connect(manager_,SIGNAL(finished(QNetworkReply*)), SLOT(onRequestFinish(QNetworkReply*)));
}

void Loader::onRequestFinish(QNetworkReply *reply)
{
	if(reply->error() == QNetworkReply::NoError) {
		QByteArray ba = reply->readAll();
		emit data(id_, ba);
	}
	else
		emit error(id_);

	deleteLater();
}

