#ifndef LOADER_H
#define LOADER_H

#include <QNetworkAccessManager>
#include <QNetworkReply>

class Loader : public QObject
{
	Q_OBJECT
public:
	Loader(QString id, QObject *p);
	~Loader();
	void start(const QString& url);
	void setProxy(QString host, int port, QString user = QString(), QString pass = QString());

private slots:
	void onRequestFinish(QNetworkReply*);

signals:
	void error(QString);
	void data(QString, QByteArray);

private:
	QNetworkAccessManager* manager_;
	QString id_;
};

#endif // LOADER_H
