#include "editnote.h"


EditNote::EditNote( QWidget *parent, QString tags, QString title, QString text, QModelIndex index)
        :QDialog(parent)
        , index_(index)
{
    setAttribute(Qt::WA_DeleteOnClose);
    setModal(false);
    ui_.setupUi(this);

    ui_.le_title->setText(title);
    ui_.le_tags->setText(tags);
    ui_.pte_text->insertPlainText(text);

    connect(ui_.pb_ok, SIGNAL(released()), this, SLOT(ok()));
    connect(ui_.pb_cancel, SIGNAL(released()), this, SLOT(close()));

}

EditNote::~EditNote()
{
}

void EditNote::ok()
{
    QString text = ui_.pte_text->toPlainText();
    QString title = ui_.le_title->text();
    QString tags = ui_.le_tags->text();    

   QDomDocument doc;
   QDomElement noteElem = doc.createElement("note");
   QDomElement titleElem = doc.createElement("title");
   QDomElement textElem = doc.createElement("text");
   textElem.appendChild(doc.createTextNode(text));
   titleElem.appendChild(doc.createTextNode(title));
   noteElem.setAttribute("tags", tags);
   noteElem.appendChild(titleElem);
   noteElem.appendChild(textElem);
   doc.appendChild(noteElem);

   if(!text.isEmpty() || !title.isEmpty() || !tags.isEmpty())
        newNote(doc.documentElement());

   editNote(doc.documentElement(), index_);

   close();
}

