#ifndef TAGSMODEL_H
#define TAGSMODEL_H

#include <QAbstractListModel>
#include <QSortFilterProxyModel>
#include <QDomElement>
#include <QStringList>

class TagModel : public QAbstractListModel
{
    Q_OBJECT

 public:
     TagModel(QObject *parent = 0) : QAbstractListModel(parent) {}

     int rowCount(const QModelIndex &parent = QModelIndex()) const;
     QVariant data(const QModelIndex &index, int role) const;
     void addTag(QString tag);
     void removeTag(QString tag);
     void clear();
     QModelIndex indexByTag(QString tag) const;

 private:
     QStringList stringList;

 };

class NoteModel : public QAbstractListModel
{
    Q_OBJECT

 public:

    enum RoleType {
        NoteRole = Qt::DisplayRole + 1,
        TagRole = Qt::DisplayRole + 2,
        TitleRole = Qt::DisplayRole + 3
    };

     NoteModel(QObject *parent = 0);

     int rowCount(const QModelIndex &parent = QModelIndex()) const;
     QVariant data(const QModelIndex &index, int role) const;
     void clear();
     void addNote(QDomElement note);
     void delNote(const QModelIndex &index);
     void insertNote(QDomElement note, const QModelIndex &index);
     void editNote(QDomElement note, const QModelIndex &index);
     QList<QDomElement> getAllNotes();
     QStringList getAllTags();

 private:
     QList<QDomElement> notesList;

 };

class ProxyModel : public QSortFilterProxyModel
{
    Q_OBJECT

public:
    ProxyModel(QObject *parent = 0) : QSortFilterProxyModel(parent) {};
    bool filterAcceptsRow(int sourceRow, const QModelIndex &parent) const;
};
#endif // TAGSMODEL_H
