#ifndef VIEW_H
#define VIEW_H

#include <QTableView>
#include <QKeyEvent>

#include "iconfactoryaccessinghost.h"
#include "delegate.h"

class Viewer : public QTableView
{
    Q_OBJECT

    public:
        Viewer(QWidget *parent = 0) : QTableView(parent) {};
        void init(IconFactoryAccessingHost *iconHost);

    private:
        IconFactoryAccessingHost *iconHost_;

   protected:
        void keyPressEvent(QKeyEvent *e);
        void contextMenuEvent( QContextMenuEvent * e );

   private slots:
        void itemClicked(QModelIndex index);

   signals:
        void getSound(QModelIndex index);
        void checkSound(QModelIndex index);

};

#endif // VIEW_H
