import os, os.path, sys, string, shutil, glob

# this file defines the commands for updating the init
# methods (constructors) of the widget classes for pyFLTK
# run this before issuing the SWIG command


PythonOwns = ['Fl_Preferences']

def parseFltkFile(file_name):
    fp = open(file_name)
    lines = fp.readlines()
    fp.close()
    replace = 0

    isClass = 0
    new_lines = []
    for line in lines:
        if isClass == 1:
            if string.find(line, "self.thisown = 1") >= 0:
                line = string.replace(line, "self.thisown = 1", "self.thisown = 0")
                #print line
                #print "self.thisown = 0"
                isClass = 0
                replace += 1
            elif string.find(line, "self.this.append(this)") >= 0:
                # add white spaces
                space_len = len(line)-len(line.lstrip())
                new_line = ""
                for i in range(space_len):
                    new_line += " "
                new_line += "this.own(0)\n"
                new_lines.append(new_line)
                isClass = 0
                replace += 1
            elif string.find(line, "swiginit(self") > 0:
                # add white spaces
                space_len = len(line)-len(line.lstrip())
                new_line = ""
                for i in range(space_len):
                    new_line += " "
                new_line += "self.this.disown()\n"
                new_lines.append(line)
                line = new_line
                isClass = 0
                replace += 1

        new_lines.append(line)
        if string.find(line, "class") == 0:
            isClass = 1
            # extract class name
            pos = string.find(line, "(")
            if pos > 6:
                class_name = line[6:pos]
                #print class_name
                if class_name in PythonOwns:
                    print "Python owns ", class_name
                    isClass = 0
            
            #print line
            
    fp = open(file_name, 'w')
    fp.writelines(new_lines)
    fp.close()
    print "Replaced %d occurences!"%replace

def is_msys_mingw():
    if os.environ.has_key("MSYSTEM"):
        if os.environ["MSYSTEM"] == "MINGW32":
            return True
    return False

if __name__=='__main__':
    # call SWIG
    include = ['-I/usr/include']
    try:
        fltk_dir = os.environ['FLTK_HOME']
        include.insert(0, "-I%s"%fltk_dir)
    except:
        print "Using default location for FLTK!"
        if is_msys_mingw():
            result = os.popen('sh fltk-config --cxxflags').readlines()
        else:
            result = os.popen('fltk-config --cxxflags').readlines()
        print result
        if len(result) > 0:
            p_inc = map(lambda x: x.strip(), result[0].split(' '))
            for item in p_inc:
                if string.find(item, '-I') == 0:
                    include.insert(0, item)
        else:
            print "FLTK not found!"
            sys.exit(0)
    
    add_incl = string.join(include, ' ')
    
        
    # command line for swig-1.3.28 or later
    cmd_line = "swig -w312 -w451 -w473 -I../swig %s -DFL_EXPORT -DPYTHON -module fltk -c++ -python -shadow -modern -dirprot -fastdispatch -o fltk_wrap.cpp ../swig/fltk.i "%add_incl
    # command line for swig-1.3.27
    # cmd_line = "swig -w312 -w451 -w473 -I../swig %s -DFL_EXPORT -DPYTHON -module fltk -c++ -python -shadow -modern -dirprot -o fltk_wrap.cpp ../swig/fltk.i "%add_incl
    if is_msys_mingw():
        # adjust the paths so that MinGW can understand it
        cmd_line = cmd_line.replace("\\", "/")
        cmd_line = cmd_line.replace("c:", "/c")
        cmd_line = cmd_line.replace("C:", "/c")

        import tempfile
        tmpfn = tempfile.mktemp(suffix='run_swig')
        tmpf = open(tmpfn, "w+b")
        tmpf.write(cmd_line)
        tmpf.close()
        r = os.system("sh %s" % tmpfn)

        os.remove(tmpfn)
        if r != 0:
            raise DistutilsExecError, \
                  "command '%s' failed with exit status :%d: command was :%s:.  " % (cmd[0], r, cmpl)
        
        print "return value of the command is :%s:" % r
    else:
        print cmd_line
        os.system(cmd_line)

    # parse fltk.py
    #print "Reset ownership!"
    #parseFltkFile("fltk.py")

    print "Copy fltk.py"
    if os.path.isdir("../fltk"):
        shutil.rmtree("../fltk");
    os.mkdir("../fltk");
    os.mkdir("../fltk/test");
    os.mkdir("../fltk/docs");
    
    shutil.copyfile("fltk.py", "../fltk/__init__.py")
    map(lambda x: shutil.copy(x, "../fltk/test"), glob.glob("../test/*.py"))
    map(lambda x: shutil.copy(x, "../fltk/test"), glob.glob("../test/*.html"))
    map(lambda x: shutil.copy(x, "../fltk/test"), glob.glob("../test/*.gif"))
    map(lambda x: shutil.copy(x, "../fltk/docs"), glob.glob("../docs/*.html"))
    map(lambda x: shutil.copy(x, "../fltk/docs"), glob.glob("../docs/*.jpg"))
             


    
    
