#!/usr/bin/env python


uri = "http://libgpiv.sourceforge.net/doc/"
print "Testing and example program of the pygpiv module that provides" 
print "libgpiv functionality in the Python scripting-language."
print "Documentation of the libgpiv functions is found at: \n", uri

# Use gpiv python module as:
#import _pygpiv
# Calling a function then is done following: pygpiv.funcion()
# or as:
from _pygpiv import *
# Calling a function then is done following: funcion()



def warnerr(warn_msg='my_msg', err_msg='my_error'):
	"""Prints error and warning message.

	Keyword arguments:
	warn_msg -- warning message. Default: my_msg
	err_msg -- error message. Default: my_error
	"""
	gpiv_warning(warn_msg)
	gperr = gpiv_error	# Just remame a function to a new variable
	gperr(err_msg)



def w_defs():
	"""Writes definitions from gpiv.h."""

        print 'W_DEFS'
	print 'GPIV_SYSTEM_RSC_FILE = ', GPIV_SYSTEM_RSC_FILE
	print 'GPIV_HOME_RSC_FILE = ', GPIV_HOME_RSC_FILE
	print 'GPIV_NIMG_MAX = ', GPIV_NIMG_MAX
	print 'GPIV_MAX_CHARS = ', GPIV_MAX_CHARS
	print 'GPIV_MAX_LINES = ', GPIV_MAX_LINES
	print 'GPIV_MAX_LINES_C = ', GPIV_MAX_LINES_C
	print 'GPIV_MAX_IMG_SIZE = ', GPIV_MAX_IMG_SIZE
	print 'GPIV_MAX_IMG_DEPTH = ', GPIV_MAX_IMG_DEPTH
	print 'GPIV_MIN_INTERR_SIZE = ', GPIV_MIN_INTERR_SIZE
	print 'GPIV_MAX_INTERR_SIZE = ', GPIV_MAX_INTERR_SIZE
	print 'GPIV_NBINS_MAX = ', GPIV_NBINS_MAX
	print 'GPIV_NBINS_DEFAULT = ', GPIV_NBINS_DEFAULT
	print 'GPIV_SNR_NAN = ', GPIV_SNR_NAN
	print 'SYSTEM_RSC_DIR = ', SYSTEM_RSC_DIR



def rw_params(parfile = "gpivrc"):
	"""Reads and writes parameters from configuration and to stdout.

	Keyword arguments:
	parfile -- parameter filename. Default: gpivrc
	"""
        print 'RW_PARAMS'
        print 'Reading interrogation parameters from $HOME/gpivrc'
	print 'or from system wide configuration file gpiv.conf'
	piv_par = gpiv_piv_get_parameters_from_resources(parfile, TRUE)
	valid_par = gpiv_valid_get_parameters_from_resources(parfile, TRUE)
	post_par = gpiv_post_get_parameters_from_resources(parfile, TRUE)



def rw_pivdata(infile = "img1.piv",
	       outfile = "out.piv"):
	"""Reads and writes piv data from file and to stdout.
	
	Keyword arguments:
	infile -- piv-data filename. Default: img1.piv
	outfile -- piv-data filename. Default: out.piv
	"""
	print 'RW_PIVDATA'
	print 'Reading  piv_data from:  ', infile
	print 'Writing  piv_data to:    ', outfile
	piv_data = gpiv_fread_pivdata(infile)
	gpiv_fwrite_pivdata(outfile, piv_data, TRUE)	



def piv_interrogate_image(infile = "img1.png",
			  outfile = "img1.piv",
			  parfile = "gpivrc",
			  verbose = FALSE,
			  stdout = FALSE):
	"""Interrogates an image to obtain PIV estimators.
	
	Keyword arguments:
	infile -- image input filename. Default: img1.png
	outfile -- PIV output filename. Default: img1.piv
	parfile -- parameter filename. Default: gpivrc
	verbose -- prints behaviour to stdout. Default: FALSE
	stdout -- prints PIV data to stdout. Default: FALSE
	"""

	if (verbose):
		print 'PIV_INTERROGATE_IMAGE'
		print 'Loading image from:      ', infile
	piv_par = gpiv_piv_get_parameters_from_resources(parfile, verbose)
	valid_par = gpiv_valid_get_parameters_from_resources(parfile, verbose)
	image = gpiv_fread_image(infile)
	piv_data = gpiv_piv_interrogate_img(image, piv_par, valid_par, verbose)
	if (verbose):
		print "Writing PIV data to:     ", outfile
	gpiv_fwrite_pivdata(outfile, piv_data, FALSE)
	if (stdout):
		print "Writing PIV data to stdout"
		gpiv_write_pivdata (None, piv_data, TRUE)
	print "Finished!"




# Enable or disable to call some or all functions
#w_defs()
#rw_params()
piv_interrogate_image(verbose = TRUE)
#rw_pivdata()
#warnerr("another warning msg", "another error msg")
#warnerr()
