## groups.py
## 
## Copyright (C) 2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import pygtk
pygtk.require('2.0')
import gtk
import gobject 

import dialog
import handlers
import mainwindow
import pyNeighborhood

class Groups_Widget:
    
    def instance(self):
        return self
    
    def menuaction_handler_scan_groups(self, parm1):
        handlers.scan_groups(self, self.mainwindow, "common")

    def menuaction_handler_scan_groups_msbrowse(self, parm1):
        handlers.scan_groups(self, self.mainwindow, "msbrowse")

    def menuaction_handler_scan(self, parm1):
        handlers.scan(self, self.mainwindow)
		
    def menuaction_handler_umount(self, parm1):
        self.mainwindow.umount()

    def menuaction_handler_mount(self, parm1, type):
        handlers.mount(self, self.mainwindow, type)
		
    def menuaction_handler_filemngr(self, parm1, label):
        handlers.filemanager(self, self.mainwindow, label)

    def menuaction_handler_add(self, parm1):
        handlers.add_from_group(self, self.mainwindow)

    def widget_popup(self, type, mounted):
        popup = gtk.Menu()
        separator = gtk.SeparatorMenuItem()
        if type == "groups_menu":
            if pyNeighborhood.parser.get_value("msbrowse") == "True":
                item1 = gtk.ImageMenuItem("SCAN_MSBROWSE")
                item1.connect("activate", self.menuaction_handler_scan_groups_msbrowse)
                popup.append(item1)
            if pyNeighborhood.parser.get_value("msbrowse") == "False":
                item1 = gtk.ImageMenuItem("SCAN")
                item1.connect("activate", self.menuaction_handler_scan_groups)
                item2 = gtk.ImageMenuItem("SCAN_MSBROWSE")
                item2.connect("activate", self.menuaction_handler_scan_groups_msbrowse)
                popup.append(item1)
                popup.append(item2)
        if type == "workgroup_menu":
            item1 = gtk.ImageMenuItem("SCAN")
            item1.connect("activate", self.menuaction_handler_scan_groups)
            popup.append(item1)
        if type == "host_menu":
            item2 = gtk.ImageMenuItem(gtk.STOCK_ADD)
            item2.connect("activate", self.menuaction_handler_add)
            popup.append(item2)
        menu = popup
        return menu

    def select_on_click(self, treeview):
        treestore = treeview.get_selection()
        (model, iter) = treestore.get_selected()
        if self.if_popup == 1:
            if model.iter_parent(iter) == None:
                menu = self.widget_popup("groups_menu", False)
            else:
                if model.iter_parent(model.iter_parent(iter)) == None:
                    menu = self.widget_popup("workgroup_menu", False)
                else:
                    if model.iter_parent(model.iter_parent(model.iter_parent(iter))) == None:
                        menu = self.widget_popup("host_menu", False)

            menu.popup(None, None, None, 3, gtk.get_current_event_time())
            menu.show_all()
            self.if_popup = 0

    def button_clicked(self, widget, event):
        if event.type == gtk.gdk._2BUTTON_PRESS and event.button == 1:
            treeselection = self.treeview.get_selection()
            (model, iter) = treeselection.get_selected()
            if iter != None:
                column = self.treeview.get_column(0)
                if model.iter_parent(iter) == None:
                    handlers.scan_groups(self, self.mainwindow, "msbrowse")
                else:
                    if model.iter_parent(model.iter_parent(iter)) == None:
                        handlers.scan_groups(self, self.mainwindow, "msbrowse")
                    else:
                        if model.iter_parent(model.iter_parent(model.iter_parent(iter))) == None:
                            handlers.add_from_group(self, self.mainwindow)

        if event.type == gtk.gdk.BUTTON_PRESS and event.button == 3:
            self.if_popup = 1

    def Groups(self):
        # bookmarks
        self.column_names = ['Name', 'Comment']

        # if 1, menu pops up
        self.if_popup = 0

        iter = self.treestore.append(None, ["Groups", "groups", ""])
        self.treestore.set(iter, 2, '')

        # create the TreeView using treestore
        tvcolumn = [None] * len(self.column_names)

        # create 2 TreeViewColumns to display the data
        cell = gtk.CellRendererText()
        cell1 = gtk.CellRendererText()
        cellpb = gtk.CellRendererPixbuf()
       	tvcolumn[0] = gtk.TreeViewColumn(self.column_names[0])
       	self.treeview.append_column(tvcolumn[0])

       	tvcolumn[0].pack_start(cellpb, False)
       	tvcolumn[0].pack_start(cell, True)
       	tvcolumn[0].set_attributes(cellpb, stock_id=1)
       	tvcolumn[0].set_attributes(cell, text=0)

       	tvcolumn[0].set_resizable(True)
        for n in range (1, len(self.column_names)):
            tvcolumn[n] = gtk.TreeViewColumn(self.column_names[n])
            self.treeview.append_column(tvcolumn[n])
            tvcolumn[n].pack_start(cell1, True)
            tvcolumn[n].set_attributes(cell1, text=n+1)
            tvcolumn[n].set_resizable(True)

        self.treeview.set_expander_column(self.treeview.get_column(0))

        # create scrollbars
        scrolledwindow = gtk.ScrolledWindow()
        scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrolledwindow.add(self.treeview)

        # make it searchable and connect popups
        self.treeview.set_search_column(1)
        self.treeview.connect("cursor-changed", self.select_on_click)
        self.treeview.connect("button_press_event", self.button_clicked)

        return scrolledwindow, self.treestore, self.treeview

    def __init__(self, MainWindow):
        # create a TreeStore with one string column to use as the model
        self.treestore = gtk.TreeStore(str, str, str)
        self.treeview = gtk.TreeView(self.treestore)
        self.mainwindow = MainWindow

