## handlers.py
## 
## Copyright (C) 2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import dialog
import threads
import pyNeighborhood

def scan_groups(ParentWidget, MainWindow, type):
    treeselection = ParentWidget.treeview.get_selection()
    (model, iter) = treeselection.get_selected()
    path = model.get_path(iter)
    if model.iter_parent(iter) == None:
        print "Using Append_Groups_Thread"
        thr = threads.Append_Groups_Thread(ParentWidget.treeview,
                                           path,
                                           ParentWidget.treestore, type)
        thr.start()
    else:
        thr = threads.Append_Workgroup_Thread(ParentWidget.treeview,
                                              path,
                                              ParentWidget.treestore)
        thr.start()
        print "Using Append_Workgroup_Thread"
    return

def scan(ParentWidget, MainWindow, prompt):
    treeselection = ParentWidget.treeview.get_selection()
    (model, iter) = treeselection.get_selected()
    if iter != None:
        path = model.get_path(iter)
        column = ParentWidget.treeview.get_column(0)
        try:
            path = model.get_path(iter)
        except:
            dialog.dialog("Please select a host to scan", None)
        if MainWindow.notebook.get_current_page() == 0:
            if model.iter_parent(iter) == None:
                pyNeighborhood.user = pyNeighborhood.parser.get_value("user") 
                pyNeighborhood.password = pyNeighborhood.parser.get_value("password")
#                if pyNeighborhood.parser.get_value("enable_default") == "False" and pyNeighborhood.parser.get_value("anonymous") == "False":
                if prompt:
                    if not dialog.user_password(MainWindow.window, "Scan as user"):
                        return
                else:
                    pyNeighborhood.user = pyNeighborhood.parser.get_value("user") 
                    pyNeighborhood.password = pyNeighborhood.parser.get_value("password")
                
                #
                # Fixme: duplicated code block 1
                #
                model = ParentWidget.treeview.get_model()
                iter = model.get_iter(path)
                current_name = model.get_value(iter, 0)
                is_last_iter = False
                #check whether we are trying to scan a last share
                if model.iter_next(iter) == None:
                    is_last_iter = True
                    useiter = model.iter_parent(iter)
                else:
                    useiter = iter
        
                comment = ParentWidget.treestore.get_value(iter, 2)
                ParentWidget.treestore.remove(iter)
                if is_last_iter == False:
                    newiter = ParentWidget.treestore.insert_before(None, useiter, [current_name, "host", comment, ""])
                else:
                    newiter = ParentWidget.treestore.append(useiter,[current_name, "host", comment, ""])
                treeselection.select_iter(newiter)
                #
                # End of duplicated code
                #

                thr = threads.Append_Share_Thread(ParentWidget.treeview,
                                            path,
                                            column,
                                            ParentWidget.treestore, newiter)
                thr.start()
            else:
                print "Current selection is a share."
                dialog.dialog("Current selection is a share.", MainWindow.window)
    return

def remove(ParentWidget, MainWindow):
    treeselection = ParentWidget.treeview.get_selection()
    (model, iter) = treeselection.get_selected()
    if iter == None:
        return
    path = model.get_path(iter)
    model = ParentWidget.treeview.get_model()
    iter = model.get_iter(path)
    current_host = model.get_value(iter, 0)
    if model.iter_parent(iter) == None:
        ParentWidget.treestore.remove(iter)
        pyNeighborhood.hosts.remove(current_host)
    else:
        print "Current selection is a share."
        dialog.dialog("Current selection is a share.", MainWindow.window)
    return

def filemanager(ParentWidget, MainWindow, label):
    treeselection = ParentWidget.treeview.get_selection()
    (model, iter) = treeselection.get_selected()
    if iter != None:
        thr = threads.Fmanager_Thread(MainWindow.notebook,
                                      ParentWidget.treeview, label)
        thr.start()

def mount(ParentWidget, MainWindow, type, prompt):
    treeselection = ParentWidget.treeview.get_selection()
    (model, iter) = treeselection.get_selected()
    if iter != None:
        path = model.get_path(iter)
        column = ParentWidget.treeview.get_column(0)
        if model.iter_parent(iter) != None:
#            if pyNeighborhood.parser.get_value("enable_default") == "False" and pyNeighborhood.parser.get_value("anonymous") == "False":
            if prompt:
                if not dialog.user_password(MainWindow.window, "Mount as user"):
                    return
            else:
                pyNeighborhood.user = pyNeighborhood.parser.get_value("user") 
                pyNeighborhood.password = pyNeighborhood.parser.get_value("password")

            thr = threads.Mount_Thread(ParentWidget.treeview,  
                                       path, 
                                       column, 
                                       ParentWidget.treestore, 
                                       MainWindow.notebook,
                                       type)
            thr.start()
        else:
            dialog.dialog("Current selection is a hostname.\nFailed to mount.", MainWindow.window)
    return

def edit(ParentWidget, MainWindow):
    treeselection = ParentWidget.treeview.get_selection()
    (model, iter) = treeselection.get_selected()
    path = model.get_path(iter)
    model = ParentWidget.treeview.get_model()
    iter = model.get_iter(path)
    current_host = model.get_value(iter, 0)
    if model.iter_parent(iter) == None:
        #
        # Fixme: duplicated code block 1
        #
        model = ParentWidget.treeview.get_model()
        iter = model.get_iter(path)
        current_name = model.get_value(iter, 0)
        is_last_iter = False
        #check whether we are trying to scan a last share
        if model.iter_next(iter) == None:
            is_last_iter = True
            useiter = model.iter_parent(iter)
        else:
            useiter = iter

        comment = ParentWidget.treestore.get_value(iter, 2)
        ParentWidget.treestore.remove(iter)
        if is_last_iter == False:
            newiter = ParentWidget.treestore.insert_before(None, useiter, [current_name, "host", comment, ""])
        else:
            newiter = ParentWidget.treestore.append(useiter,[current_name, "host", comment, ""])
        treeselection.select_iter(newiter)
        #
        # End of duplicated code
        #

        editmachine = dialog.EditMachine(MainWindow.window)
        display, name, ip =  editmachine.editmachine(ParentWidget)
        if display != None: 
            pyNeighborhood.hosts.update(current_host, display, name, ip)
            model.set_value(newiter, 0, display)
    else:
        print "Current selection is a share."
        dialog.dialog("Current selection is a share.", MainWindow.window)
    return

def add(ParentWidget, MainWindow):
    addmachine = dialog.EditMachine(MainWindow.window)
    try:
        display, name, ip = addmachine.addmachine()
    except:
        display, name, ip = None, None, None
    print display, name, ip 
    if display != None: 
        ParentWidget.treestore.append(None, [display, "host", "", ""])
        pyNeighborhood.hosts.add(display, name, ip)
    return

def add_from_group(ParentWidget, MainWindow):
    addmachine = dialog.EditMachine(MainWindow.window)
    display, name, ip = addmachine.addmachine_group(ParentWidget)
    print display, name, ip 
    if display != None: 
        MainWindow.treestore.append(None, [display, "host", "", ""])
        pyNeighborhood.hosts.add(display, name, ip)
    return

