## pyNeighborhood.py
## 
## Copyright (C) 2005-2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import pygtk
pygtk.require('2.0')
import gtk
import gobject 
import os
import string
import threading
from os import system, environ, path, getenv, mkdir, getcwd
from shutil import copy

import mainwindow
import config
import optparser
import hostsparser

parser = optparser.OptionsParser(getenv("HOME")+"/.pyNeighborhood"+"/"+"options.conf")
hosts = hostsparser.HostsParser(getenv("HOME")+"/.pyNeighborhood"+"/"+"hosts.conf")
workgroups = []
masters = []
master_ips = []
user = parser.get_value("user")
password = parser.get_value("password")
statusbar = gtk.Statusbar()
progressbar  = gtk.ProgressBar()

groups_scan_lock = False
shares_scan_locks = []
workgroups_scan_locks = []

message_success = "success"
message_failed = "failed"

def set_default_mount_type():
    if parser.get_value("enable_smb") == "True":
        return "SMB"
    if parser.get_value("enable_cifs") == "True":
        return "CIFS"

default_mount_type = set_default_mount_type()

#
# Remove unuseful spaces
#
def unpad(str):
    if str == '':
        return str
    else:            
        splitted = str.split(" ")
        non_empty_list = []
        for sym in splitted:
            if sym == '':
                pass
            else:
                non_empty_list.append(sym)
        unpadded_line = string.join(non_empty_list)
        return unpadded_line

def update_statusbar(statusbar, message):
    statusbar.pop(0)
    statusbar.push(0, message)

def ip_validator(ip_address):
    list = ip_address.split(".")
    if len(list) != 4:
        return False
    for num in list:
        try:
            int(num)
        except:
            return False
    return True

class iconset:
    def __init__(self, path):
        #
        # Register pyNeighborhood iconset
        #
        iconfactory = gtk.IconFactory()
        hosts_icon = gtk.gdk.pixbuf_new_from_file(string.join([path, "host.png"], '/'))
        share_icon = gtk.gdk.pixbuf_new_from_file(string.join([path, "share.png"], '/'))
        pyn_icon = gtk.gdk.pixbuf_new_from_file(string.join([path, "pyneighborhood.png"], '/'))
        groups_icon = gtk.gdk.pixbuf_new_from_file(string.join([path, "groups.png"], '/'))
        workgroup_icon = gtk.gdk.pixbuf_new_from_file(string.join([path, "workgroup.png"], '/'))

        iconset = gtk.IconSet(hosts_icon)
        iconfactory.add('host', iconset)

        iconset = gtk.IconSet(share_icon)
        iconfactory.add('share', iconset)

        iconset = gtk.IconSet(pyn_icon)
        iconfactory.add('pyneigh', iconset)

        iconset = gtk.IconSet(groups_icon)
        iconfactory.add('groups', iconset)

        iconset = gtk.IconSet(workgroup_icon)
        iconfactory.add('workgroup', iconset)
        #
        # Add custom stock icons
        #
        item = [("MOUNT", "Mount", gtk.gdk.CONTROL_MASK, 0, ''),
                ("MOUNT_USER", "Mount as user", gtk.gdk.CONTROL_MASK, 0, ''),
                ("UNMOUNT", "Unmount", gtk.gdk.CONTROL_MASK, 0, ''),
                ("SCAN", "Scan", gtk.gdk.CONTROL_MASK, 0, ''),
                ("SCAN_USER", "Scan as user", gtk.gdk.CONTROL_MASK, 0, ''),
                ("SCAN_MSBROWSE", "Scan using msbrowse", gtk.gdk.CONTROL_MASK, 0, ''),
                ("FILEMANAGER", "File Manager", gtk.gdk.CONTROL_MASK, 0, '')]
        gtk.stock_add(item)

        pixbuf = gtk.gdk.pixbuf_new_from_file(string.join([path, "mount.png"], '/'))
        pixbuf = pixbuf.add_alpha(True, chr(0xff), chr(0xff), chr(0xff))
        iconset = gtk.IconSet (pixbuf)
        iconfactory.add ("MOUNT", iconset)

        pixbuf = gtk.gdk.pixbuf_new_from_file(string.join([path, "mount.png"], '/'))
        pixbuf = pixbuf.add_alpha(True, chr(0xff), chr(0xff), chr(0xff))
        iconset = gtk.IconSet (pixbuf)
        iconfactory.add ("MOUNT_USER", iconset)

        pixbuf = gtk.gdk.pixbuf_new_from_file(string.join([path, "unmount.png"], '/'))
        pixbuf = pixbuf.add_alpha(True, chr(0xff), chr(0xff), chr(0xff))
        iconset = gtk.IconSet (pixbuf)
        iconfactory.add ("UNMOUNT", iconset)

        pixbuf = gtk.gdk.pixbuf_new_from_file(string.join([path, "scan.png"], '/'))
        pixbuf = pixbuf.add_alpha(True, chr(0xff), chr(0xff), chr(0xff))
        iconset = gtk.IconSet (pixbuf)
        iconfactory.add ("SCAN", iconset)

        pixbuf = gtk.gdk.pixbuf_new_from_file(string.join([path, "scan.png"], '/'))
        pixbuf = pixbuf.add_alpha(True, chr(0xff), chr(0xff), chr(0xff))
        iconset = gtk.IconSet (pixbuf)
        iconfactory.add ("SCAN_USER", iconset)

        pixbuf = gtk.gdk.pixbuf_new_from_file(string.join([path, "scan.png"], '/'))
        pixbuf = pixbuf.add_alpha(True, chr(0xff), chr(0xff), chr(0xff))
        iconset = gtk.IconSet (pixbuf)
        iconfactory.add ("SCAN_MSBROWSE", iconset)

        pixbuf = gtk.gdk.pixbuf_new_from_file(string.join([path, "filemanager.png"], '/'))
        pixbuf = pixbuf.add_alpha(True, chr(0xff), chr(0xff), chr(0xff))
        iconset = gtk.IconSet (pixbuf)
        iconfactory.add ("FILEMANAGER", iconset)

        iconfactory.add_default()
        return 

if __name__ == "__main__":
    try: 
        iconset("icons")
    except:
        iconset(string.join([config.config(), '/', 'share', '/', 'pyNeighborhood', '/', 'icons'], ''))

    cur_dir = os.getenv("PWD")

    mainwindow.MainWindow()
    mainwindow.main()
 
