#! /usr/bin/env python
"""
Sample for python PCSC wrapper module: List card attributes

__author__ = "http://www.gemalto.com"

Copyright 2001-2008 gemalto
Author: Jean-Daniel Aussel, mailto:jean-daniel.aussel@gemalto.com

This file is part of pyscard.

pyscard is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or
(at your option) any later version.

pyscard is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with pyscard; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""

import struct
from smartcard.scard import *

if 'winscard'==resourceManager:
    attributes = {
        SCARD_ATTR_VENDOR_NAME              : 'SCARD_ATTR_VENDOR_NAME'              ,
        SCARD_ATTR_VENDOR_IFD_TYPE          : 'SCARD_ATTR_VENDOR_IFD_TYPE'          ,
        SCARD_ATTR_VENDOR_IFD_VERSION       : 'SCARD_ATTR_VENDOR_IFD_VERSION'       ,
        SCARD_ATTR_VENDOR_IFD_SERIAL_NO     : 'SCARD_ATTR_VENDOR_IFD_SERIAL_NO'     ,
        SCARD_ATTR_CHANNEL_ID               : 'SCARD_ATTR_CHANNEL_ID'               ,
        SCARD_ATTR_DEFAULT_CLK              : 'SCARD_ATTR_DEFAULT_CLK'              ,
        SCARD_ATTR_MAX_CLK                  : 'SCARD_ATTR_MAX_CLK'                  ,
        SCARD_ATTR_DEFAULT_DATA_RATE        : 'SCARD_ATTR_DEFAULT_DATA_RATE'        ,
        SCARD_ATTR_MAX_DATA_RATE            : 'SCARD_ATTR_MAX_DATA_RATE'            ,
        SCARD_ATTR_MAX_IFSD                 : 'SCARD_ATTR_MAX_IFSD'                 ,
        SCARD_ATTR_POWER_MGMT_SUPPORT       : 'SCARD_ATTR_POWER_MGMT_SUPPORT'       ,
        SCARD_ATTR_USER_TO_CARD_AUTH_DEVICE : 'SCARD_ATTR_USER_TO_CARD_AUTH_DEVICE' ,
        SCARD_ATTR_USER_AUTH_INPUT_DEVICE   : 'SCARD_ATTR_USER_AUTH_INPUT_DEVICE'   ,
        SCARD_ATTR_CHARACTERISTICS          : 'SCARD_ATTR_CHARACTERISTICS'          ,
        SCARD_ATTR_CURRENT_PROTOCOL_TYPE    : 'SCARD_ATTR_CURRENT_PROTOCOL_TYPE'    ,
        SCARD_ATTR_CURRENT_CLK              : 'SCARD_ATTR_CURRENT_CLK'              ,
        SCARD_ATTR_CURRENT_F                : 'SCARD_ATTR_CURRENT_F'                ,
        SCARD_ATTR_CURRENT_D                : 'SCARD_ATTR_CURRENT_D'                ,
        SCARD_ATTR_CURRENT_N                : 'SCARD_ATTR_CURRENT_N'                ,
        SCARD_ATTR_CURRENT_W                : 'SCARD_ATTR_CURRENT_W'                ,
        SCARD_ATTR_CURRENT_IFSC             : 'SCARD_ATTR_CURRENT_IFSC'             ,
        SCARD_ATTR_CURRENT_IFSD             : 'SCARD_ATTR_CURRENT_IFSD'             ,
        SCARD_ATTR_CURRENT_BWT              : 'SCARD_ATTR_CURRENT_BWT'              ,
        SCARD_ATTR_CURRENT_CWT              : 'SCARD_ATTR_CURRENT_CWT'              ,
        SCARD_ATTR_CURRENT_EBC_ENCODING     : 'SCARD_ATTR_CURRENT_EBC_ENCODING'     ,
        SCARD_ATTR_EXTENDED_BWT             : 'SCARD_ATTR_EXTENDED_BWT'             ,
        SCARD_ATTR_ICC_PRESENCE             : 'SCARD_ATTR_ICC_PRESENCE'             ,
        SCARD_ATTR_ICC_INTERFACE_STATUS     : 'SCARD_ATTR_ICC_INTERFACE_STATUS'     ,
        SCARD_ATTR_CURRENT_IO_STATE         : 'SCARD_ATTR_CURRENT_IO_STATE'         ,
        SCARD_ATTR_ATR_STRING               : 'SCARD_ATTR_ATR_STRING'               ,
        SCARD_ATTR_ICC_TYPE_PER_ATR         : 'SCARD_ATTR_ICC_TYPE_PER_ATR'         ,
        SCARD_ATTR_ESC_RESET                : 'SCARD_ATTR_ESC_RESET'                ,
        SCARD_ATTR_ESC_CANCEL               : 'SCARD_ATTR_ESC_CANCEL'               ,
        SCARD_ATTR_ESC_AUTHREQUEST          : 'SCARD_ATTR_ESC_AUTHREQUEST'          ,
        SCARD_ATTR_MAXINPUT                 : 'SCARD_ATTR_MAXINPUT'                 ,
        SCARD_ATTR_DEVICE_UNIT              : 'SCARD_ATTR_DEVICE_UNIT'              ,
        SCARD_ATTR_DEVICE_IN_USE            : 'SCARD_ATTR_DEVICE_IN_USE'            ,
        SCARD_ATTR_DEVICE_FRIENDLY_NAME_A   : 'SCARD_ATTR_DEVICE_FRIENDLY_NAME_A'   ,
        SCARD_ATTR_DEVICE_SYSTEM_NAME_A     : 'SCARD_ATTR_DEVICE_SYSTEM_NAME_A'     ,
        SCARD_ATTR_DEVICE_FRIENDLY_NAME_W   : 'SCARD_ATTR_DEVICE_FRIENDLY_NAME_W'   ,
        SCARD_ATTR_DEVICE_SYSTEM_NAME_W     : 'SCARD_ATTR_DEVICE_SYSTEM_NAME_W'     ,
        SCARD_ATTR_SUPRESS_T1_IFS_REQUEST   : 'SCARD_ATTR_SUPRESS_T1_IFS_REQUEST'
    }
elif 'pcsclite'==resourceManager and 'pcsclite-tiger'!=resourceManagerSubType:
    attributes = {
        SCARD_ATTR_VENDOR_NAME              : 'SCARD_ATTR_VENDOR_NAME',
        SCARD_ATTR_VENDOR_IFD_TYPE          : 'SCARD_ATTR_VENDOR_IFD_TYPE',
        SCARD_ATTR_VENDOR_IFD_VERSION       : 'SCARD_ATTR_VENDOR_IFD_VERSION',
        SCARD_ATTR_VENDOR_IFD_SERIAL_NO     : 'SCARD_ATTR_VENDOR_IFD_SERIAL_NO',
        SCARD_ATTR_CHANNEL_ID               : 'SCARD_ATTR_CHANNEL_ID',
        SCARD_ATTR_ASYNC_PROTOCOL_TYPES     : 'SCARD_ATTR_ASYNC_PROTOCOL_TYPES',
        SCARD_ATTR_DEFAULT_CLK              : 'SCARD_ATTR_DEFAULT_CLK',
        SCARD_ATTR_MAX_CLK                  : 'SCARD_ATTR_MAX_CLK',
        SCARD_ATTR_DEFAULT_DATA_RATE        : 'SCARD_ATTR_DEFAULT_DATA_RATE',
        SCARD_ATTR_MAX_DATA_RATE            : 'SCARD_ATTR_MAX_DATA_RATE',
        SCARD_ATTR_MAX_IFSD                 : 'SCARD_ATTR_MAX_IFSD',
        SCARD_ATTR_SYNC_PROTOCOL_TYPES      : 'SCARD_ATTR_SYNC_PROTOCOL_TYPES',
        SCARD_ATTR_POWER_MGMT_SUPPORT       : 'SCARD_ATTR_POWER_MGMT_SUPPORT',
        SCARD_ATTR_USER_TO_CARD_AUTH_DEVICE : 'SCARD_ATTR_USER_TO_CARD_AUTH_DEVICE',
        SCARD_ATTR_USER_AUTH_INPUT_DEVICE   : 'SCARD_ATTR_USER_AUTH_INPUT_DEVICE',
        SCARD_ATTR_CHARACTERISTICS          : 'SCARD_ATTR_CHARACTERISTICS',
        SCARD_ATTR_CURRENT_PROTOCOL_TYPE    : 'SCARD_ATTR_CURRENT_PROTOCOL_TYPE',
        SCARD_ATTR_CURRENT_CLK              : 'SCARD_ATTR_CURRENT_CLK',
        SCARD_ATTR_CURRENT_F                : 'SCARD_ATTR_CURRENT_F',
        SCARD_ATTR_CURRENT_D                : 'SCARD_ATTR_CURRENT_D',
        SCARD_ATTR_CURRENT_N                : 'SCARD_ATTR_CURRENT_N',
        SCARD_ATTR_CURRENT_W                : 'SCARD_ATTR_CURRENT_W',
        SCARD_ATTR_CURRENT_IFSC             : 'SCARD_ATTR_CURRENT_IFSC',
        SCARD_ATTR_CURRENT_IFSD             : 'SCARD_ATTR_CURRENT_IFSD',
        SCARD_ATTR_CURRENT_BWT              : 'SCARD_ATTR_CURRENT_BWT',
        SCARD_ATTR_CURRENT_CWT              : 'SCARD_ATTR_CURRENT_CWT',
        SCARD_ATTR_CURRENT_EBC_ENCODING     : 'SCARD_ATTR_CURRENT_EBC_ENCODING',
        SCARD_ATTR_EXTENDED_BWT             : 'SCARD_ATTR_EXTENDED_BWT',
        SCARD_ATTR_ICC_PRESENCE             : 'SCARD_ATTR_ICC_PRESENCE',
        SCARD_ATTR_ICC_INTERFACE_STATUS     : 'SCARD_ATTR_ICC_INTERFACE_STATUS',
        SCARD_ATTR_CURRENT_IO_STATE         : 'SCARD_ATTR_CURRENT_IO_STATE',
        SCARD_ATTR_ATR_STRING               : 'SCARD_ATTR_ATR_STRING',
        SCARD_ATTR_ICC_TYPE_PER_ATR         : 'SCARD_ATTR_ICC_TYPE_PER_ATR',
        SCARD_ATTR_ESC_RESET                : 'SCARD_ATTR_ESC_RESET',
        SCARD_ATTR_ESC_CANCEL               : 'SCARD_ATTR_ESC_CANCEL',
        SCARD_ATTR_ESC_AUTHREQUEST          : 'SCARD_ATTR_ESC_AUTHREQUEST',
        SCARD_ATTR_MAXINPUT                 : 'SCARD_ATTR_MAXINPUT',
        SCARD_ATTR_DEVICE_UNIT              : 'SCARD_ATTR_DEVICE_UNIT',
        SCARD_ATTR_DEVICE_IN_USE            : 'SCARD_ATTR_DEVICE_IN_USE',
        SCARD_ATTR_DEVICE_FRIENDLY_NAME_A   : 'SCARD_ATTR_DEVICE_FRIENDLY_NAME_A',
        SCARD_ATTR_DEVICE_SYSTEM_NAME_A     : 'SCARD_ATTR_DEVICE_SYSTEM_NAME_A',
        SCARD_ATTR_DEVICE_FRIENDLY_NAME_W   : 'SCARD_ATTR_DEVICE_FRIENDLY_NAME_W',
        SCARD_ATTR_DEVICE_SYSTEM_NAME_W     : 'SCARD_ATTR_DEVICE_SYSTEM_NAME_W',
        SCARD_ATTR_SUPRESS_T1_IFS_REQUEST   : 'SCARD_ATTR_SUPRESS_T1_IFS_REQUEST'
    }
else:
    attributes={}


def printAttribute( attrib, value ):
    print '-----------------', attributes[attrib], '-----------------'
    print value
    for j in xrange(len(value)):
        print "0x%.2X" % value[j],
    print ""
    print apply( struct.pack, [ '<' + 'B' * len(value)] + value )


try:
    hresult, hcontext = SCardEstablishContext( SCARD_SCOPE_USER )
    if hresult!=0:
        raise error, 'Faile to establish context: ' + SCardGetErrorMessage(hresult)
    print 'Context established!'

    try:
        hresult, readers = SCardListReaders( hcontext, [] )
        if hresult!=0:
            raise error, 'Failed to list readers: ' + SCardGetErrorMessage(hresult)
        print 'PCSC Readers:', readers

        if len(readers)<1:
            raise error, 'No smart card readers'
        print 'Trying to retreive attributes of', readers[0]

        for reader in readers:
            hresult, hcard, dwActiveProtocol = SCardConnect(
                hcontext, reader, SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0 )
            if hresult!=0:
                print error, 'Unable to connect: ' + SCardGetErrorMessage(hresult)
            else:

                print 'Connected with active protocol', dwActiveProtocol

                try:
                    for i in attributes.keys():
                        hresult, attrib = SCardGetAttrib( hcard, i )
                        if hresult==0:
                            printAttribute( i, attrib )
                        else:
                            print '-----------------', attributes[i], '-----------------'
                            print 'unsupported'

                finally:
                    hresult = SCardDisconnect( hcard, SCARD_UNPOWER_CARD )
                    if hresult!=0:
                        raise error, 'Failed to disconnect: ' + SCardGetErrorMessage(hresult)
                    print 'Disconnected'

    finally:
        hresult = SCardReleaseContext( hcontext )
        if hresult!=0:
            raise error, 'Failed to release context: ' + SCardGetErrorMessage(hresult)
        print 'Released context.'

except error:
    import sys
    print sys.exc_info()[0], ':', sys.exc_info()[1]

import sys
if 'win32'==sys.platform:
    print 'press Enter to continue'
    sys.stdin.read(1)

