import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, TestCaseIgnored
from launchpadbugs.lpconstants import HTTPCONNECTION
from launchpadbugs.html_buglist import BugPage, BugInfo, ExpBugInfo, BugInfoWatches, BugList
from launchpadbugs.http_connection import HTTPConnection

con = None

class HTMLBugListTestCase(PyLPBugsTestCase):
    
    def test_001_setup_HTTPConnection(self):
        """ prepare the HTTPConnection object """
        global con
        con = HTTPConnection()
            
    def test_002_package_bugs(self):
        """[STABLE/EDGE] test package bugs """
        url = "https://bugs.launchpad.net/ubuntu/+source/hal"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bugiter, next, batchsize, length = BugPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                bug = bugiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(bug, BugInfo), "wrong type of 'bug' in mode '%s'" %k)
            
    def test_003_personal_bugs(self):
        """[STABLE/EDGE] test personal bugs """
        url = "https://bugs.edge.launchpad.net/~thekorn"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bugiter, next, batchsize, length = BugPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                bug = bugiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(bug, BugInfo), "wrong type of 'bug' in mode '%s'" %k)
            
    def test_004_milestone_bugs(self):
        """[STABLE/EDGE] test milestone bugs """
        url = "https://bugs.edge.launchpad.net/ubuntu/+milestone/ubuntu-8.04-beta"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bugiter, next, batchsize, length = BugPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                bug = bugiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(bug, BugInfo), "wrong type of 'bug' in mode '%s'" %k)
            
    def test_005_expirable_bugs(self):
        """[STABLE/EDGE] test expirable bugs """
        url = "https://bugs.edge.launchpad.net/ubuntu/+expirable-bugs"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bugiter, next, batchsize, length = BugPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                bug = bugiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(bug, ExpBugInfo), "wrong type of 'bug' in mode '%s'" %k)
            
    def test_006_bugtracker_bugs(self):
        """[STABLE/EDGE] test bugtracker bugs """
        url = "https://edge.launchpad.net/bugs/bugtrackers/alsa-mantis"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bugiter, next, batchsize, length = BugPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                bug = bugiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(bug, BugInfoWatches), "wrong type of 'bug' in mode '%s'" %k)
            
    def test_007_buglist(self):
        """ test BugList """
        url1 = "https://bugs.launchpad.net/bughelper/+bugs"
        url2 = "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bugs"
        BL1 = BugList(url1, con)
        BL2 = BugList(url2, con)
        BL1 += BL2
        x = BL1.sort("-nr")
        y = BL1.sort("status")
        

if __name__ == '__main__':
    import unittest
    
    HTMLBugListTestSuite = unittest.TestLoader().loadTestsFromTestCase(HTMLBugListTestCase)
    
    alltests = PyLPBugsTestSuite((HTMLBugListTestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
