#!/usr/bin/python

from person                      import Person
from bug                         import Bug
from milestone                   import Milestone

# BugTask
#
class BugTask(object):
    # __init__
    #
    def __init__(self, service, lp_bug_task):
        self.__service = service
        self.__lp_bug_task = lp_bug_task
        self.__owner        = None
        self.__bug_target_display_name = None
        self.__bug_target_name = None

    # __str__
    #
    def __str__(self):
        return self.display_name

    # owner
    #
    @property
    def owner(self):
        if self.__owner == None:
            self.__owner = Person(None, self.__lp_bug_task.owner)
        return self.__owner

    # bug_target_display_name
    #
    @property
    def bug_target_display_name(self):
        if self.__bug_target_display_name == None:
            self.__bug_target_display_name = self.__lp_bug_task.bug_target_display_name
        return self.__bug_target_display_name

    # bug_target_name
    #
    @property
    def bug_target_name(self):
        if self.__bug_target_name == None:
            self.__bug_target_name = self.__lp_bug_task.bug_target_display_name
        return self.__bug_target_name

    # bug
    #
    @property
    def bug(self):
        return Bug(self.__service, self.__lp_bug_task.bug.id)

    # status
    #
    @property
    def status(self):
        return self.__lp_bug_task.status

    @status.setter
    def status(self, value):
        self.__lp_bug_task.status = value
        self.__lp_bug_task.lp_save()
        return

    # title
    #
    @property
    def title(self):
        return self.__lp_bug_task.title

    # is_complete
    #
    @property
    def is_complete(self):
        return self.__lp_bug_task.is_complete


    # importance
    #
    @property
    def importance(self):
        return self.__lp_bug_task.importance

    @importance.setter
    def importance(self, value):
        self.__lp_bug_task.importance = value
        self.__lp_bug_task.lp_save()
        return

    # assignee
    #
    @property
    def assignee(self):
        if self.__lp_bug_task.assignee != None:
            return self.__lp_bug_task.assignee
        else:
            return None

    # date_assigned
    #
    @property
    def date_assigned(self):
        return self.__lp_bug_task.date_assigned

    # date_closed
    #
    @property
    def date_closed(self):
        return self.__lp_bug_task.date_closed

    # date_confirmed
    #
    @property
    def date_confirmed(self):
        return self.__lp_bug_task.date_confirmed

    # date_created
    #
    @property
    def date_created(self):
        return self.__lp_bug_task.date_created

    # date_fix_committed
    #
    @property
    def date_fix_committed(self):
        return self.__lp_bug_task.date_fix_committed

    # date_fix_released
    #
    @property
    def date_fix_released(self):
        return self.__lp_bug_task.date_fix_released

    # date_in_progress
    #
    @property
    def date_in_progress(self):
        return self.__lp_bug_task.date_in_progress

    # date_incomplete
    #
    @property
    def date_incomplete(self):
        return self.__lp_bug_task.date_incomplete

    # date_left_closed
    #
    @property
    def date_left_closed(self):
        return self.__lp_bug_task.date_left_closed

    # date_left_new
    #
    @property
    def date_left_new(self):
        return self.__lp_bug_task.date_left_new

    # date_triaged
    #
    @property
    def date_triaged(self):
        return self.__lp_bug_task.date_triaged

    # milestone
    #
    @property
    def milestone(self):
        if self.__lp_bug_task.milestone != None:
            return Milestone(self.__service, self.__lp_bug_task.milestone)
        else:
            return None

# vi:set ts=4 sw=4 expandtab:
