#!/usr/bin/python

from arsenal.arsenal_lib import *
from lpltk import LaunchpadService

if len(sys.argv) < 2:
    sys.stderr.write("Usage: %s <tag> <source-package>\n" %(sys.argv[0]) )
    sys.exit(1)

total_count = 0
tag         = sys.argv[1]
source_pkgs = sys.argv[2:]
lp          = LaunchpadService(config={'read_only':True})
d           = lp.launchpad.distributions["ubuntu"]

print "== Bugs tagged '" + tag + "' =="
for source_pkg in source_pkgs:
    count = 0
    print "=== " + source_pkg + " ==="
    s = d.getSourcePackage(name = source_pkg)
    for bugtask in s.searchTasks(tags=tag):
        bug = ArsenalBug(bugtask.bug, lp.launchpad)
        print bug.id, " " + bugtask.status + " " + bug.title
        count += 1
        total_count += 1

print total_count, " total bugs tagged '" + tag + "'"
