# PySNMP SMI module. Autogenerated from smidump -f python INET-ADDRESS-MIB
# by libsmi2pysnmp-0.0.7-alpha at Wed Feb  7 16:12:58 2007,
# Python version (2, 4, 3, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( Bits, Integer32, ModuleIdentity, MibIdentifier, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "TimeTicks", "Unsigned32", "mib-2")
( TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention")

# Types

class InetAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,255)
    pass

class InetAddressDNS(TextualConvention, OctetString):
    displayHint = "255a"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(1,255)
    pass

class InetAddressIPv4(TextualConvention, OctetString):
    displayHint = "1d.1d.1d.1d"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(4,4)
    fixedLength = 4
    pass

class InetAddressIPv4z(TextualConvention, OctetString):
    displayHint = "1d.1d.1d.1d%4d"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(8,8)
    fixedLength = 8
    pass

class InetAddressIPv6(TextualConvention, OctetString):
    displayHint = "2x:2x:2x:2x:2x:2x:2x:2x"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(16,16)
    fixedLength = 16
    pass

class InetAddressIPv6z(TextualConvention, OctetString):
    displayHint = "2x:2x:2x:2x:2x:2x:2x:2x%4d"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(20,20)
    fixedLength = 20
    pass

class InetAddressPrefixLength(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(0,2040)
    pass

class InetAddressType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(4,0,3,1,16,2,)
    namedValues = namedval.NamedValues(("unknown", 0), ("ipv4", 1), ("dns", 16), ("ipv6", 2), ("ipv4z", 3), ("ipv6z", 4), )
    pass

class InetAutonomousSystemNumber(TextualConvention, Unsigned32):
    displayHint = "d"
    pass

class InetPortNumber(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(0,65535)
    pass

class InetScopeType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,3,4,5,1,14,8,)
    namedValues = namedval.NamedValues(("interfaceLocal", 1), ("global", 14), ("linkLocal", 2), ("subnetLocal", 3), ("adminLocal", 4), ("siteLocal", 5), ("organizationLocal", 8), )
    pass

class InetVersion(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(0,1,2,)
    namedValues = namedval.NamedValues(("unknown", 0), ("ipv4", 1), ("ipv6", 2), )
    pass

class InetZoneIndex(TextualConvention, Unsigned32):
    displayHint = "d"
    pass


# Objects

inetAddressMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 76)).setRevisions(("2005-02-04 00:00","2002-05-09 00:00","2000-06-08 00:00",))

# Augmentions

# Exports

# Module identity
mibBuilder.exportSymbols("INET-ADDRESS-MIB", PYSNMP_MODULE_ID=inetAddressMIB)

# Types
mibBuilder.exportSymbols("INET-ADDRESS-MIB", InetAddress=InetAddress, InetAddressDNS=InetAddressDNS, InetAddressIPv4=InetAddressIPv4, InetAddressIPv4z=InetAddressIPv4z, InetAddressIPv6=InetAddressIPv6, InetAddressIPv6z=InetAddressIPv6z, InetAddressPrefixLength=InetAddressPrefixLength, InetAddressType=InetAddressType, InetAutonomousSystemNumber=InetAutonomousSystemNumber, InetPortNumber=InetPortNumber, InetScopeType=InetScopeType, InetVersion=InetVersion, InetZoneIndex=InetZoneIndex)

# Objects
mibBuilder.exportSymbols("INET-ADDRESS-MIB", inetAddressMIB=inetAddressMIB)

