# -*- coding: utf-8 -*-

# Copyright (C) 2010-2011 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
#
# Python X2go is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Python X2go is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""\
L{X2goSessionProfiles} class - managing x2goclient session profiles.

L{X2goSessionProfiles} is a public API class. Use this class in your Python X2go based 
applications.

"""
__NAME__ = 'x2gosessionprofiles-pylib'

import copy

# Python X2go modules
from x2go.defaults import X2GO_SESSIONPROFILES_CONFIGFILES
from x2go.defaults import X2GO_SESSIONPROFILE_DEFAULTS
import x2go.inifiles as inifiles
import x2go.log as log
import x2go.utils as hostname 

from x2go.x2go_exceptions import X2goProfileException


class X2goSessionProfilesWINREG(inifiles.X2goIniFile):

    defaultSessionProfile = X2GO_SESSIONPROFILE_DEFAULTS
    _non_profile_sections = ('embedded')

    def __init__(self, config_files=X2GO_SESSIONPROFILES_CONFIGFILES, defaults=None, session_profile_defaults=None, logger=None, loglevel=log.loglevel_DEFAULT):
        """\
        STILL UNDOCUMENTED

        """
        raise X2goNotImplementedYetException('WINREG backend support is not implemented yet')

