/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLOptionElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFormElement.h"
#include "HTMLOptionElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLOptionElement)

/* Hash table */

static const HashTableValue JSHTMLOptionElementTableValues[10] =
{
    { "form", DontDelete|ReadOnly, (intptr_t)jsHTMLOptionElementForm, (intptr_t)0 },
    { "defaultSelected", DontDelete, (intptr_t)jsHTMLOptionElementDefaultSelected, (intptr_t)setJSHTMLOptionElementDefaultSelected },
    { "text", DontDelete, (intptr_t)jsHTMLOptionElementText, (intptr_t)setJSHTMLOptionElementText },
    { "index", DontDelete|ReadOnly, (intptr_t)jsHTMLOptionElementIndex, (intptr_t)0 },
    { "disabled", DontDelete, (intptr_t)jsHTMLOptionElementDisabled, (intptr_t)setJSHTMLOptionElementDisabled },
    { "label", DontDelete, (intptr_t)jsHTMLOptionElementLabel, (intptr_t)setJSHTMLOptionElementLabel },
    { "selected", DontDelete, (intptr_t)jsHTMLOptionElementSelected, (intptr_t)setJSHTMLOptionElementSelected },
    { "value", DontDelete, (intptr_t)jsHTMLOptionElementValue, (intptr_t)setJSHTMLOptionElementValue },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLOptionElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLOptionElementTableValues, 0 };
#else
    { 34, 31, JSHTMLOptionElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLOptionElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLOptionElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLOptionElementConstructorTableValues, 0 };
#endif

class JSHTMLOptionElementConstructor : public DOMObject {
public:
    JSHTMLOptionElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLOptionElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLOptionElementPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLOptionElementConstructor::s_info = { "HTMLOptionElementConstructor", 0, &JSHTMLOptionElementConstructorTable, 0 };

bool JSHTMLOptionElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptionElementConstructor, DOMObject>(exec, &JSHTMLOptionElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLOptionElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLOptionElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLOptionElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLOptionElementPrototype::s_info = { "HTMLOptionElementPrototype", 0, &JSHTMLOptionElementPrototypeTable, 0 };

JSObject* JSHTMLOptionElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLOptionElement>(exec, globalObject);
}

const ClassInfo JSHTMLOptionElement::s_info = { "HTMLOptionElement", &JSHTMLElement::s_info, &JSHTMLOptionElementTable, 0 };

JSHTMLOptionElement::JSHTMLOptionElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLOptionElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLOptionElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLOptionElementPrototype(JSHTMLOptionElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLOptionElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptionElement, Base>(exec, &JSHTMLOptionElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLOptionElementForm(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->form()));
}

JSValuePtr jsHTMLOptionElementDefaultSelected(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->defaultSelected());
}

JSValuePtr jsHTMLOptionElementText(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->text());
}

JSValuePtr jsHTMLOptionElementIndex(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->index());
}

JSValuePtr jsHTMLOptionElementDisabled(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->disabled());
}

JSValuePtr jsHTMLOptionElementLabel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->label());
}

JSValuePtr jsHTMLOptionElementSelected(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->selected());
}

JSValuePtr jsHTMLOptionElementValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->value());
}

JSValuePtr jsHTMLOptionElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLOptionElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLOptionElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLOptionElement, Base>(exec, propertyName, value, &JSHTMLOptionElementTable, this, slot);
}

void setJSHTMLOptionElementDefaultSelected(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setDefaultSelected(value->toBoolean(exec));
}

void setJSHTMLOptionElementText(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSHTMLOptionElementDisabled(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setDisabled(value->toBoolean(exec));
}

void setJSHTMLOptionElementLabel(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setLabel(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLOptionElementSelected(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setSelected(value->toBoolean(exec));
}

void setJSHTMLOptionElementValue(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(static_cast<JSHTMLOptionElement*>(thisObject)->impl());
    imp->setValue(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLOptionElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLOptionElementConstructor>(exec);
}

HTMLOptionElement* toHTMLOptionElement(JSC::JSValuePtr value)
{
    return value->isObject(&JSHTMLOptionElement::s_info) ? static_cast<JSHTMLOptionElement*>(asObject(value))->impl() : 0;
}

}
