/*
    This file is part of qTox, a Qt-based graphical interface for Tox.

    This program is libre software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    See the COPYING file for more details.
*/

#ifndef ADVANCEDFORM_H
#define ADVANCEDFORM_H

#include "genericsettings.h"

class Core;

namespace Ui {
class AdvancedSettings;
}

class AdvancedForm : public GenericForm
{
    Q_OBJECT
public:
    AdvancedForm();
    virtual ~AdvancedForm();
    
protected:
    bool eventFilter(QObject *o, QEvent *e);

private slots:
    void onMakeToxPortableUpdated();
    void onDbSyncTypeUpdated();
    void resetToDefault();

private:
    Ui::AdvancedSettings* bodyUI;
};

#endif // ADVANCEDFORM_H
