/*
    Copyright (C) 2014 by Project Tox <https://tox.im>

    This file is part of qTox, a Qt-based graphical interface for Tox.

    This program is libre software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    See the COPYING file for more details.
*/


#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>

namespace Ui {
class Widget;
}

class Widget : public QWidget
{
    Q_OBJECT

public:
    explicit Widget(QWidget *parent = 0);
    ~Widget();

    // Utilities
    void deleteBackups();
    void restoreBackups();
    void setProgress(int value);

    // Noreturn
    void fatalError(QString message); ///< Calls deleteUpdate and startQToxAndExit
    void deleteUpdate();
    void startQToxAndExit();

public slots:
    // Finds and applies the update
    void update();

private:
    Ui::Widget *ui;
    QStringList backups;
};

#endif // WIDGET_H
