#include "atom.h"
#include <fcntl.h>

extern unsigned char * volatile fb_mem, *volatile ctrl_mem;
  static struct card_info my_card_info;

char *object_names[] = { "NONE",
			 "INTERNAL LVDS",
			 "INTERNAL TMDS1",
			 "INTERNAL TMDS2",
			 "INTERNAL DAC1",
			 "INTERNAL DAC2",
			 "INTERNAL SDVOA",
			 "INTERNAL SDVOB",
			 "SI170B",
			 "CH7303",
			 "CH7301",
			 "INTERNAL DVO1",
			 "EXTERNAL SDVOA",
			 "EXTERNAL SDVOB",
			 "TI TFP513",
			 "INTERNAL LVTM1",
			 "VT1623",
			 "HDMI SI1930",
			 "HDMI INTERNAL",
			 "INTERNAL KLDSCP TMDS1",
			 "INTERNAL KLDSCP DVO1",
			 "INTERNAL KLDSCP DAC1",
			 "INTERNAL KLDSCP DAC2",
			 "SI178",
			 "MVPU FPGA",
			 "INTERNAL DDI",
			 "VT1625",
			 "HDMI SI1932",
			 "DP AN9801",
			 "DP DP501",
			 "INTERNAL UNIPHY",
			 "INTERNAL KLDSCP LVTMA",
			 "INTERNAL UNIPHY1",
			 "INTERNAL UNIPHY2"
};
			 
char *connector_names[] = { "NONE",
			    "SL DVI-I",
			    "DL DVI-I",
			    "SL DVI-D",
			    "DL DVI-D",
			    "VGA",
			    "COMPOSITE",
			    "SVIDEO",
			    "YPbPr",
			    "D_CONNECTOR",
			    "9PIN_DIN",
			    "SCART",
			    "HDMI A",
			    "HDMI B",
			    "LVDS",
			    "7PIN_DIN",
			    "PCIE CONNECTOR",
			    "CROSSFIRE",
			    "HARDCODE_DVI",
			    "DISPLAYPORT",
};

void radeon_lookup_gpio(struct atom_context *ctx, uint8_t id)
{
	ATOM_GPIO_I2C_ASSIGMENT gpio;
	int index = GetIndexIntoMasterTable(DATA, GPIO_I2C_Info);
	struct _ATOM_GPIO_I2C_INFO *i2c_info;
	uint16_t data_offset;

	atom_parse_data_header(ctx, index, NULL, NULL, NULL, &data_offset);

	i2c_info = (struct _ATOM_GPIO_I2C_INFO *)(ctx->bios + data_offset);

	gpio = i2c_info->asGPIO_Info[id];

	printf("GPIO %d: %04x\n", id, gpio.usClkMaskRegisterIndex *4);
}

void radeon_dump_bios_object_table(struct atom_context *ctx)
{
	uint16_t size, data_offset;
	uint8_t frev, crev;
	int index = GetIndexIntoMasterTable(DATA, Object_Header);
	ATOM_CONNECTOR_OBJECT_TABLE *con_obj;
	ATOM_INTEGRATED_SYSTEM_INFO_V2 *igp_obj = NULL;
	ATOM_OBJECT_HEADER *obj_header;
	int i, j;

	atom_parse_data_header(ctx, index, &size, &frev, &crev, &data_offset);

	if (crev < 2)
		return;

	obj_header = (ATOM_OBJECT_HEADER *)(ctx->bios + data_offset);

	con_obj = (ATOM_CONNECTOR_OBJECT_TABLE *)(ctx->bios + data_offset + obj_header->usConnectorObjectTableOffset);

	printf("Num of objects %d\n", con_obj->ucNumberOfObjects);

	for (i = 0; i < con_obj->ucNumberOfObjects; i++) {
		ATOM_SRC_DST_TABLE_FOR_ONE_OBJECT *src_dst_table;
		ATOM_COMMON_RECORD_HEADER *record;
		uint8_t obj_id, num, obj_type;
		int record_base;
		uint16_t con_obj_id = le16_to_cpu(con_obj->asObjects[i].usObjectID);
		obj_id = (con_obj_id & OBJECT_ID_MASK) >> OBJECT_ID_SHIFT;
		num = (con_obj_id & ENUM_ID_MASK) >> ENUM_ID_SHIFT;
		obj_type = (con_obj_id & OBJECT_TYPE_MASK) >> OBJECT_TYPE_SHIFT;
		if (obj_type != GRAPH_OBJECT_TYPE_CONNECTOR)
			continue;

		printf("object id %04x %02x %s\n", obj_id, src_dst_table->ucNumberOfSrc, connector_names[obj_id]);
		src_dst_table = (ATOM_SRC_DST_TABLE_FOR_ONE_OBJECT *)
			(ctx->bios + data_offset + le16_to_cpu(con_obj->asObjects[i].usSrcDstTableOffset));

		for (j = 0; j < src_dst_table->ucNumberOfSrc; j++) {
			uint8_t sobj_id;
			sobj_id = (src_dst_table->usSrcObjectID[j] & OBJECT_ID_MASK) >> OBJECT_ID_SHIFT;
			printf("src object id %04x 0x%02x %s\n", src_dst_table->usSrcObjectID[j], sobj_id, object_names[sobj_id]);
		}

		record = (ATOM_COMMON_RECORD_HEADER *)
			(ctx->bios + data_offset + le16_to_cpu(con_obj->asObjects[i].usRecordOffset));
		record_base = le16_to_cpu(con_obj->asObjects[i].usRecordOffset);

		while (record->ucRecordType > 0 &&
		       record->ucRecordType <= ATOM_MAX_OBJECT_RECORD_NUMBER) {
			printf("record type %d\n", record->ucRecordType);

			switch(record->ucRecordType) {
			case ATOM_I2C_RECORD_TYPE:
			{
				ATOM_I2C_RECORD *i2c_record = (ATOM_I2C_RECORD *)record;
				printf("i2c mux:%d engine:%d hw_cap:%d\n",
				       i2c_record->sucI2cId.bfI2C_LineMux,
				       i2c_record->sucI2cId.bfHW_EngineID,
				       i2c_record->sucI2cId.bfHW_Capable);
				radeon_lookup_gpio(ctx, i2c_record->sucI2cId.bfI2C_LineMux);
			}
			break;
			case ATOM_HPD_INT_RECORD_TYPE:
				break;
			case ATOM_CONNECTOR_DEVICE_TAG_RECORD_TYPE:
				break;
			}
			record = (ATOM_COMMON_RECORD_HEADER *)((char *)record + record->ucRecordSize);
		}

	}
}

void radeon_dump_bios_connector_table(struct atom_context *ctx)
{


}

void radeon_execute_aux_channel_table(struct atom_context *ctx)
{
	int index = GetIndexIntoMasterTable(COMMAND, ProcessAuxChannelTransaction);
	PROCESS_AUX_CHANNEL_TRANSACTION_PARAMETERS params;

	memset(&params, 0, sizeof(params));

	params.lpAuxRequest = 0;
	params.lpDataOut = 0x100;
	params.ucChannelID = 0;
	
	atom_execute_table(ctx, index, (uint32_t *)&params);

}




void dump_vram_table(struct atom_context *ctx)
{
	int index = GetIndexIntoMasterTable(DATA, VRAM_UsageByFirmware);
	uint16_t data_offset;
	uint8_t crev, frev;
	uint16_t size;
	ATOM_VRAM_USAGE_BY_FIRMWARE *vram_usage;
	uint16_t fw_bytes;
	uint32_t start_offset;
	
	atom_parse_data_header(ctx, index, &size, &frev, &crev, &data_offset);

	vram_usage = (struct _ATOM_VRAM_USAGE_BY_FIRMWARE *)(ctx->bios + data_offset);
	start_offset = vram_usage->asFirmwareVramReserveInfo[0].ulStartAddrUsedByFirmware;
	fw_bytes = vram_usage->asFirmwareVramReserveInfo[0].usFirmwareUseInKb * 1024;
	printf("vram_usage 0x%08x %dkb\n", 
	       vram_usage->asFirmwareVramReserveInfo[0].ulStartAddrUsedByFirmware,
	       vram_usage->asFirmwareVramReserveInfo[0].usFirmwareUseInKb);

	if (!fb_mem)
		printf("No card to dump VRAM from\n");
	else {
		void *backing;
		int fd;

		backing = kzalloc(fw_bytes, GFP_KERNEL);

		start_offset &= 0xfffffff;
		memcpy(backing, fb_mem + start_offset, fw_bytes);

		fd = open("/tmp/vram_usage", O_RDWR | O_CREAT, 0666);

		write(fd, backing, fw_bytes);

		close(fd);

		printf("EDID offsets crt1:0x%x lcd1:0x%x dfp1:0x%x crt2:0x%x df5:0x%x\n", ATOM_CRT1_EDID_ADDR,
                       ATOM_LCD1_EDID_ADDR, ATOM_DFP1_EDID_ADDR,
                       ATOM_CRT2_EDID_ADDR, ATOM_DFP5_EDID_ADDR);
                printf("DP train 0x%x\n", ATOM_DP_TRAINING_TBL_ADDR);

	}

}

static void cail_reg_write(struct card_info *card_info, uint32_t reg, uint32_t val)
{
	printf("reg write %d, %d\n", reg, val);
//	*(unsigned int * volatile)(ctrl_mem + reg) = val;  
}

static uint32_t cail_reg_read(struct card_info *card_info, uint32_t reg)
{
	printf("reg read %d\n", reg);
	return 0; //*(unsigned int * volatile)(ctrl_mem + reg);
}

static void fake_reg_write(struct card_info *card_info, uint32_t reg, uint32_t val)
{
	printf("reg write %d, %d\n", reg, val);
//	*(unsigned int * volatile)(ctrl_mem + reg) = val;  
}

static uint32_t fake_reg_read(struct card_info *card_info, uint32_t reg)
{
	printf("reg read %d\n", reg);
	return 0; //*(unsigned int * volatile)(ctrl_mem + reg);
}

struct atom_context *atom_init(void *bios)
{
  struct atom_context *ctx;

  memset(&my_card_info, 0, sizeof(struct card_info));

  if (ctrl_mem) {
	  my_card_info.reg_read = cail_reg_read;
	  my_card_info.reg_write = cail_reg_write;
  } else {
	  my_card_info.reg_read = fake_reg_read;
	  my_card_info.reg_write = fake_reg_write;
  }

  ctx = atom_parse(&my_card_info, bios);

  atom_asic_init(ctx);
  return ctx;
}

void atom_dump(struct atom_context *ctx)
{

  radeon_dump_bios_connector_table(ctx);

  radeon_dump_bios_object_table(ctx);

  dump_vram_table(ctx);

  radeon_execute_aux_channel_table(ctx);

}
