%define version 1.2.6

Summary:        Utility for computing hash sums and creating magnet links.
Name:           rhash
Version:        %{version}
Release:        1
Copyright:      MIT
Group:          Applications/File
Vendor:         Novosibirsk, Animegorodok
Packager:       Aleksey Kravchenko
URL:            http://rhash.sourceforge.net/
Source:         http://downloads.sourceforge.net/rhash/rhash-%{version}-src.tar.gz
BuildRoot:      %{_builddir}/%{name}-%{version}-root
BuildRequires:  gcc, libopenssl1.0.0-devel

%description
RHash (Recurcive Hasher) is a console utility for computing 
and verifying magnet links and hash sums of files.
It supports CRC32, MD4, MD5, SHA1/SHA2, Tiger, DC++ TTH,
BitTorrent BTIH, AICH, eDonkey hash, GOST R 34.11-94, RIPEMD-160, 
HAS-160, EDON-R, Whirlpool and Snefru hash algorithms.
Hash sums are used to ensure and verify integrity of large volumes of data
for a long-term storing or transferring.

Program features:
 * Calculation of Magnet links and EDonkey 2000 links.
 * Output in a predefined (SFV, BSD-like) or a user-defined format.
 * Updating crc files (adding hash sums of files missing in the crc file).
 * Ability to process directories recursively.
 * Portability: the program works the same under Linux, *BSD or Windows.

%prep
%setup

%build
make OPTFLAGS="$RPM_OPT_FLAGS -DNDEBUG" ADDCFLAGS="-DUSE_OPENSSL -DOPENSSL_RUNTIME -rdynamic" ADDLDFLAGS=-ldl all test

%install
rm -rf "$RPM_BUILD_ROOT"
#mkdir -p $RPM_BUILD_ROOT/usr/bin $RPM_BUILD_ROOT/%{_mandir}/man1 $RPM_BUILD_ROOT/etc
make PREFIX=/usr DESTDIR="$RPM_BUILD_ROOT" MANDIR="%{_mandir}" install

#%clean

%files
%defattr(-,root,root)
%doc COPYING INSTALL ChangeLog rhash.1.html

/usr/bin/*
/etc/rhashrc
%{_mandir}/man1/

%changelog
* Tue Jun 14 2011 Aleksey
- === Version 1.2.6 ===
- allowed options to be intermixed with file names in arbitrary order
- switched option -G and the '%G' printf pattern to print GOST hash
- Bugfix: --output failed for cyrillic file name
- librhash: better shared library compilation/testing support
- librhash: exported benchmarking functions in the shared library
- librhash: added prefix to all functions to avoid poluting linker namespace
- librhash: fixed rare alignment bugs in rhash_print and EDON-R 512
- librhash: loading openssl at runtime if it is present
- Bugfix: LLVM GOST amd64 asm compilation error

* Wed May 18 2011 Aleksey
- === Version 1.2.5 ===
- option --openssl allows to replace some algorithms by the OpenSSL ones
- Bugfix: incorrect recursive traversing of very long UTF-8 filepaths
- Bugfix: corrected calculation of BTIH hash and torrent files

* Fri Apr 15 2011 Aleksey
- === Version 1.2.4 ===
- option --benchmark-raw for machine-readable benchmark output format
- on Intel/AMD CPUs benchmark now prints the clocks-per-byte value
- changed config file locations
- Bugfix: repaired --path-separator on linux/unix

* Sun Mar 27 2011 Aleksey
- === Version 1.2.3 ===
- one-line percent for linux/unix
- added printf modificator %{mtime} to print the last modified date of a file
- Bugfix: verification of base2-like formated md5 hash sums

* Fri Jan 14 2011 Aleksey
- === Version 1.2.2 ===
- one-line percents (windows only)
- supported EDON-R 256/512 hash sums
- increased process priority when benchmarking on windows
- Bugfix: eight hash sums were broken on PowerPC
- Bugfix: --accept/--crc-accept were not working since 1.1.9

* Tue Dec 14 2010 Aleksey
- === Version 1.2.1 ===
- options --sha224, --sha256: SHA 224/256 hash functions
- option --list-hashes: list names of all supported hashes, one per line
- option --path-separator=<character> for directories scanning
- Bugfix: GOST broken on OpenSolaris since 1.2.0
- Bugfix: broken asm compilation on openbsd and freebsd

* Sun Nov 14 2010 Aleksey
- === Version 1.2.0 ===
- --gost-cryptopro option: calculate GOST with CryptoPro parameters
- --gost-reverse option: reverse bytes in GOST hash sum
- Bugfix: btih/gost/ripemd/has160/snefru were not verified correctly in bsd and magnet formats
- Bugfix: rhash compiled by MS VC skipped files of size >4Gb

* Fri Oct 15 2010 Aleksey, Ruslan Nikolaev
- === Version 1.1.9 ===
- BugFix: options with string values were incorrectly loaded from config
- Bugfix: GOST worked incorrectly when compiled by GCC with `-O0'
- GOST algorithm x86-64 assembler optimization
- new options --uppercase and --lowercase
- new interface for internal library librhash
- windows distribution updated

* Wed Apr 14 2010 Aleksey, Xiangli Huang
- === Version 1.1.8 ===
- option --template=<file> to read printf-like template from the <file>
- ed2k links verification supported
- printf-directive starting with capital letter prints upper-cased hash, e.g. %{Gost}
- '%B','%@' modifiers to print base64/raw representation of any hash (e.g. '%BM')
- %u directive now prints url-encoded filename (is an alias for %{urlname})
- filenames in urls are now always utf8-encoded (Windows only fix)
- BugFix: `--check <dirname>' reported strange warning for dirs
- BugFix: `--recursive *' traversed parent directory .. under windows
- BugFix: linking problem on OpenSolaris

* Wed Mar 31 2010 Aleksey, Xiangli Huang
- === Version 1.1.7 ===
- Bugfix: infite loop while recursively updating hash files under Windows
- option --btih to print BitTorrent infohash
- option --torrent to create torrent file
- option --bt-private for private torrents
- option --bt-piece-length to change torrent piece length
- option --bt-announce to set torrent announcement url
- the -m option changed to be an alias for --magnet
- output tiger hash in the big-endian order
- print program version, when benchmarking
- maxdepth parameter now is checked to be a number

* Wed Feb 24 2010 Aleksey
- === Version 1.1.6 ===
- Bugfix: fixed GOST for big-endian systems
- Bugfix: buffer owerflow while parsing long command line under Windows
- Bugfix: fixed HAS-160 for big-endian systems
- Bugfix: crash while printing sfv header for files modified before 1970
- Bugfix: sfv-hash symlink now sets default print format to SFV
- Bugfix: ed2k-link symlink did not work as expected
- man page updated
- now all supported hashes are verified when cheking magnet links
- benchmark now reports the size of the hashed message

* Thu Jan 28 2010 Aleksey
- === Version 1.1.5 ===
- option --utf8 under Windows, also UTF8 now is the default encoding
- ED2K switched to use eMule algorithm when filesize is an exact multiple of 9728000 bytes
- AICH algorithm has been re-written to process files of unknown size like stdin, pipes, sockets
- option --embed-crc-delimiter=<char> to insert <char> before a crc sum in -e mode
- alias -e for --embed-crc
- alias -B for --benchmark
- added `%R' printf entity for RIPEMD-160
- Bugfix: percents output fixed for files of more than 4Gb of data
- Bugfix: non-existing files were reported twice in `-r --sfv' mode
- Bugfix: buffer overflow when printing eDonkey links for 0-sized files
- Bugfix: --ripemd160 and --md4 option were broken

* Mon Dec 14 2009 Aleksey
- === Version 1.1.4 ===
- supported algorithms: WHIRLPOOL, RIPEMD-160, HAS-160, GOST, MD4, SNEFRU-128, SNEFRU-256
- long printf format entities, e.g. %{md4}, %{has160}, %{gost}, %{snefru256}
- `u' printf modifier for uppercase hashes, e.g. %u{gost}
- switched to %{urlname} printf-entity for url-encoded file name
- useful symlinks are installed by `make install-symlinks'
- print file checking statistics when --check-embedded specified

* Sun Nov 29 2009 Aleksey
- === Version 1.1.3 ===
- option --check-embedded to verify files by crc32 sum embedded in their names.
- option --embed-crc to rename processed files by embedding crc32 sum into name.
- option --benchmark now prints names of tested hash sums
- Bugfix: Checking of md5 file always reported OK
- use magnet format as default if the program name contains 'magnet'
- supported checking of files containing a single hash sum without a filename
- forbid simultaneous usage of --check, --update and --check-embedded options

* Mon Jun 15 2009 Aleksey
- === Version 1.1.2 ===
- verification of files with magnet links supported
- Bugfix: --skip-ok was broken since 1.1.0
- Bugfix: checking of ed2k hashes was broken since version 1.1.0
- Bugfix: --verbose lead to crash under OpenSolaris when config file not present

* Mon Mar 23 2009 Aleksey
- === Version 1.1.1 ===
- Bugfix: some options couldn't be read from config file
- Bugfix: buffer owerflow when printing tiger hash
- Config file described in the man page

* Sat Mar 14 2009 Aleksey
- === Version 1.1.0 ===
- option --percents to print wget-like percents
- option --speed  to print per-file and total speed statistics
- option --output to write calculation and check results to a file
- option --log to log percents, speed and verbose messages
- Bugfix: fixed processing of unaligned messages in the get_crc32() function
- various small changes and refactoring

* Sat Feb 14 2009 Aleksey
- === Version 1.0.8 ===
- --magnet option supported to format sums as a magnet link
- Bugfix: printf options from config conflicted with command line

* Sun Dec 14 2008 Aleksey
- === Version 1.0.7 ===
- config file supported to load default options values
- if --verbose, report verification errors as "sum is XXXXXXXX, should be YYYYYYYY"
- '%h' modifier changed to '%x'

* Fri Nov 14 2008 Aleksey
- === Version 1.0.6 ===
- reg-file for FAR user menu
- interpret '#' as comment

Sat Sep 20 2008 ivan386
- under windows skip files openned for writing
- Bugfix: printf arguments %p and %f corrected

* Sun Sep 14 2008 Aleksey
- === Version 1.0.5 ===
- '%b','%h' modifiers to print base32/hex representation of any hash (e.g. '%bH')
- supported -p '\0' symbol
- supported setting width for filesizes (e.g. -p '%12s')
- --verbose prints read speed statistics to stderr after each file

* Wed Jul 9 2008 Aleksey
- === Version 1.0.4 ===
- AICH hashsums supported, option --aich
- --printf '%u' prints URL-encoded filename
- EDonkey links now contain URL-encoded filename and AICH hash

* Sat Jun 28 2008 Aleksey
- === Version 1.0.3 ===
- ed2k calculation fixed for files with 9728000 < filesize <= 9732096
- Big-endian processors supported for all sums

* Sat Jun 14 2008 Aleksey
- === Version 1.0.2 ===
- --benchmark option added
- locking files under win32 when calculating 'em sums
- Bugfix: updating of md5 files was broken
- Bugfix: more rigid parsing of base32/hex hash sums

* Wed May 15 2008 Aleksey
- === Version 1.0.1 ===
- Bugfix: last line without '\n' couldn't be parsed
- Bugfix: empty lines were not skipped, when verifying a crc file
- Bugfix: fixed buffer overflow for command line -p '%%%%d'
- Bugfix: fixed size calculation for stdin (rhash -p '%s' - <file)
- Changed default behavior: if no formating option are set, sfv header is printed only for --crc32
- option '--skip-ok' to skip OK messages for successfuly verified files
- option '-a' to print all supported hash sums

* Fri Dec 14 2007 Aleksey
- === Version 1.0 ===
- large files (more then 4Gb) supported

* Thu Sep 13 2007 Aleksey
- === Version 0.9.2 ===
- Checking of TTH sums supported
- Bugfix: ignore path delimiters at the end of filenames under win32

* Sun May 27 2007 Aleksey
- === Version 0.9.1 ===
- TTH hash function supported (see -T option)
- Tiger option changed to -G
- Supported parsing of windows-style paths in crc files under linux
- Bugfix: --printf="%f" under Windows printed paths instead of filenames

* Sun May 13 2007 Aleksey
- === Version 0.9 ===
- program renamed to rhash
- md5/sha1/ed2k code rewrited and slightly optimized
- Bugfix: repaired parsing of crc files with tiger hash

* Fri May 11 2007 Aleksey
- === Version 0.8.9 ===
- Bugfix: fixed broken md5 and ed2k sums verification
- Bugfix: fixed wrong Tiger hash calculation for files with (file_size % 64) >= 56
- Tiger hash optimised to be 5% faster

* Wed May 02 2007 Aleksey
- === Version 0.8.8 ===
- added options --accept and --crc-accept
- added --verbose option
- added --maxdepth option
- added check before verifying a crc file that it isn't a binary file

* Mon Apr 16 2007 Aleksey
- === Version 0.8.7 ===
- Bugfix: --update of sfv files didn't correctly work under windows
- Implemented Tiger hash function optimised for IA32
- added check before updating a crc file that it isn't a binary file

* Mon Mar 26 2007 Aleksey
- === Version 0.8.6 ===
- default format changed to SFV
- supported "-u" option to update crc files
- Ctrl+C now prints a message and partitial statistics

* Wed Jan 31 2007 Aleksey
- === Version 0.8.5 ===
- supported many short options as one argument, e.g. '-MCEr'
- option -S (--sha1) changed to -H
- Bugfix: program crashed under BSD while printing SFV file header

* Sun Nov 05 2006 Aleksey
- === Version 0.8.4 ===
- Bugfix: errors/miss stats calculation corrected
	
* Sun Oct 29 2006 Aleksey
- supported "-c -" option to check hash sums from stdin
- added stdout flushing after each processed file
- the program returns exit code 0 on success and 1 if an error occurred

* Fri Sep 08 2006 Aleksey
- corrected parsing of md5-like files with star-prepended filenames

* Wed Apr 19 2006 Aleksey
- checking of md5/sha1 files in *BSD format supported
- improved I/O errors handling

* Mon Apr 10 2006 Aleksey
- === Version 0.8.3 ===
- supported checking of files in the standart md5sum/sha1sum format
- default output format for md5/sha1/ed2k sums changed
- man page rewrited

* Thu Mar 30 2006 Aleksey
- === Version 0.8.2 ===
- GCC 2.96 supported
- Bugfix: files with .SFV extension (in uppercase) were skiped while recursive checking

* Wed Jan 25 2006 Aleksey
- === Version 0.8.1 ===
- option --check now works with --recursive
- Bugfix: corrected output format when checking files
- Bugfix: files wasn't opened as binary on Windows when checking sums

* Mon Jan 23 2006 Aleksey
- === Version 0.8 ===
- documentation now is distributed with windows version.
- some *.bat files added to windows version.
- --check option added, to verify hash sum files.
- --ansi option added (for Windows version only).
- program name is parsed now to specify default sums to compute.
- Bugfix: console Windows version now uses OEM (DOS) character set for output.

* Sat Jan 14 2006 Aleksey
- === Version 0.7 ===
- some fixes in sfv format output
- --recursive option added
- --ed2k-link option added

* Fri Sep 02 2005 Aleksey
- === Version 0.6 ===
- Bugfix: files wasn't opened as binary on win32
- --sfv format now implies uppercase hashes
- added .spec file and Makefile 'rpm' target

* Sun Aug 14 2005 Aleksey
- === Version 0.5 (The first public version) ===
- Win32 platform supported
- Bugfix: fixed calculation of md5/ed2k hashes for AMD64
