#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
# 
# scan subdirs of the top dir for *.[1-9]texi
# and order by manual number [1-9].
#
# create two (.texi) output files:
#
#	includes.texi
#	menu.texi
#
# and two (.p) Makefile dependencies files:
#
#	includes.p
#	create-texi.p
#
#=================================================
# TODO: 
#
#   The file "menu.texi" is not yet used :
#   it is hard-coded in rhelef.texi
#
#   when changing main table-of-contents 
#    in rheolef.texi
#    => need also to change the generation 
#	of the @menu in this file "merge_texi"
#
#   do a documentation of the auto-doc file flow....
#
#   when changing node names: Classes, Algorithms
#    => need also to change "merge_texi" calls in 
#	config/compiler.mk
#	config/Makefile.am
#	fem/mac/Makefile.am
#	stokes/mac/Makefile.am
#
#=================================================
prog=`expr $0 : '.*/\(.*\)' \| $0`

top_builddir=$1
shift
top_srcdir=$1
shift
subdirs=$*
  
reverse_subdirs=""
for s in $subdirs; do
  reverse_subdirs="${s} ${reverse_subdirs}"
done

/bin/rm -f includes.texi.new
echo "@c file automatically generated by ${prog}" >  includes.texi.new
echo ""                                           >> includes.texi.new

/bin/rm -f menu.texi.new
echo "@c file automatically generated by ${prog}" >  menu.texi.new
echo ""                                           >> menu.texi.new
cat >> menu.texi.new << EOF1
@menu
* Abstract::		Preliminary information. 
EOF1

/bin/rm -f includes.p
echo "# file automatically generated by ${prog}"  >  includes.p
echo ""                                           >> includes.p
echo "INCLUDED_TEXI = \\" > includes.p
echo "! file 'includes.p' created." >&2 

/bin/rm -f create-texi.p
echo "# file automatically generated by ${prog}"  >  create-texi.p
echo ""                                           >> create-texi.p
echo ""                                           >> create-texi.p
echo "! file 'create-texi.p' created." >&2 

#-----------------------------------------------
# get the way to echo "abc\c" or echo -n "abc"
#-----------------------------------------------
if (echo "testing\c"; echo 1,2,3) | grep c >/dev/null; then
  # Stardent Vistra SVR4 grep lacks -e, says ghazi@caip.rutgers.edu.
  if (echo -n testing; echo 1,2,3) | sed s/-n/xn/ | grep xn >/dev/null; then
    ac_n= ac_c='
' ac_t='        '
  else
    ac_n=-n ac_c= ac_t=
  fi
else
  ac_n= ac_c='\c' ac_t=
fi

#-----------------------------------------------
# loop on chapters = unix manual section numbers
#-----------------------------------------------

num_chapters="1 2 3 4 5 6 7 8 9"

echo "! scan and reorder manuals, as extrated from source code:"
for i in ${num_chapters}; do

  #---------------------------------------------
  # 1. find manuals such as .${i}texi on subdirs
  #---------------------------------------------
  mans=""
  for d in ${reverse_subdirs}; do
    if test $d = "."; then
	continue
    fi
    new_mans="`find ${top_builddir}/${d} -name "*\.${i}texi" -print`"
    if test x"${new_mans}" = x""; then
	continue
    fi
    mans="${mans} ${new_mans}" 
  done
  if test x"${mans}" = x""; then
      continue
  fi
  #----------------------------------------
  # 2. print chapter title
  #----------------------------------------
  case ${i} in
        1) chapter="Commands";			node_suffix="command";; 
        3) chapter="Classes";			node_suffix="class";; 
        5) chapter="Algorithms";		node_suffix="algorithm";;
        7) chapter="Forms";			node_suffix="form";; 
        9) chapter="Internals";			node_suffix="internal";; 
        *) chapter="Unknown${i}";		node_suffix="unknown${i}";;
  esac
  # echo "chapter: ${i}"
  echo ""              >> includes.texi.new
  echo "@node ${chapter},,, Top"                                  >> includes.texi.new
  echo "@chapter ${chapter}"                                      >> includes.texi.new
  echo "* ${chapter}::"		                                  >> menu.texi.new

  #----------------------------------------
  # loop on manuals and build @menu
  #----------------------------------------
  echo "@menu"                                         >> includes.texi.new
  for man in ${mans}; do

    # compute node label from filename:
    #    man     = ../config/csr.1texi 
    # -> section = csr
    section=${man}
    section=`expr ${section} : '.*/\(.*\)' \| ${section}`
    section=`expr ${section} : '\(.*\)\..texi' \| ${section}`
    section="${section} ${node_suffix}"
    echo "* ${section}::"                                         >> includes.texi.new
  done
  echo "@end menu"                                         >> includes.texi.new
  #----------------------------------------
  # loop on manuals and performs @include's
  #----------------------------------------
  for man in ${mans}; do
    #    man     = ../config/csr.1texi 
    # -> section = csr
    section=${man}
    section=`expr ${section} : '.*/\(.*\)' \| ${section}`
    section=`expr ${section} : '\(.*\)\..texi' \| ${section}`
    section="${section} ${node_suffix}"
    # echo "    section: " ${section}

    echo "@include ${man}" >> includes.texi.new
    echo "	${man} \\" >> includes.p
    echo ${ac_n} ".${ac_c}"

    location=`expr ${man} : '\(.*\)/.*' `
    if test x"${location}" != x""; then
        file=`expr ${man} : '.*/\(.*\)' \| .`
        echo "${man}: \${MEGA_FORCE}" >> create-texi.p
        echo "	@cd ${location}; \${MAKE} ${file}" >> create-texi.p
    fi
  done
done
echo ""

cat >> menu.texi.new << EOF2
* Installing::		How to install @code{rheolef}.
* Problems::		Reporting bugs.
* Copying::		How you can copy and share @code{rheolef}.
* Concept Index::	Index of concepts.
* Program Index::       Index of programs.
* Class Index::	        Index of classes.
* Form Index::          Index of bilinear forms.
* Approximation Index:: Index of polynomial approximations.
* Function Index::      Index of functions.
* File Format Index::   Index of file formats.
* Related Tool Index::  Index of related tools.
@end menu
EOF2

echo "" >> includes.p

if test -f menu.texi && diff menu.texi.new menu.texi >/dev/null; then
    /bin/rm -f menu.texi.new
    echo "! file 'menu.texi' unchanged." >&2 
else
    /bin/mv -f menu.texi.new menu.texi
    echo "! file 'menu.texi' created." >&2 
fi

if test -f includes.texi && diff includes.texi.new includes.texi >/dev/null; then
    /bin/rm -f includes.texi.new
    echo "! file 'includes.texi' unchanged." >&2 
else
    /bin/mv -f includes.texi.new includes.texi
    echo "! file 'includes.texi' created." >&2 
fi

