#include "rheolef.h"
using namespace rheolef;
using namespace std;

const Float epsilon = 0.01;

int main(int argc, char**argv) {
    geo omega (argv[1]);
    space Vh (omega, "P1");
    if (omega.dimension() <= 2) {
      Vh.block ("left"); Vh.block ("right");
    } else {
      Vh.block ("back"); Vh.block ("front");
    }
    field uh (Vh);
    if (omega.dimension() <= 2)
      uh["left"] = uh["right"] = 0;
    else
      uh["back"] = uh["front"] = 0;
    field fh (Vh, 1);

    space Qh (omega, "P0", "vector");
    field eta (Qh);
    eta ["east"] = 1;
    eta ["west"] = epsilon;
    form_diag d (eta);
    form grad (Vh, Qh, "grad"); 
    form m    (Vh, Vh, "mass"); 
    form inv_m (Qh, Qh, "inv_mass"); 
    form a = trans(grad)*(inv_m*d)*grad;
    ssk<Float> fact = ldlt(a.uu);
    uh.u = fact.solve (m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
    cout << setprecision(numeric_limits<Float>::digits10)
         << catchmark("epsilon") << epsilon << endl
         << catchmark("u")       << uh;
    return 0;
}
