#ifndef _RHEO_GEO_QMG_H
#define _RHEO_GEO_QMG_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// the struct qmg stores information
// contained in QMG mesh files and suitable
// for geo mesh informations
// NOTE: informations from CAD are skipped
//
// author: Pierre.Saramito@imag.fr
//
// date: 15 feb 2002
//
#include "rheolef/compiler.h"
#include "rheolef/point.h"
#include "rheolef/reference_element.h"

#ifdef _RHEOLEF_HAVE_SLIST
# include <slist>
#elif defined(_RHEOLEF_HAVE_SLIST_H)
# include <slist.h>
#else
# include <list>
# ifndef slist
#  define slist list
# endif
#endif

namespace rheolef { 

// not yet defined
typedef unsigned int size_type;

struct qmg{

  // typedefs:

	struct tetra {
	    tetra () {}
	    tetra (size_type a, size_type b, size_type c, size_type d)
		{ _p[0]=a; _p[1]=b; _p[2]=c; _p[3]=d; }
	    reference_element::enum_type type() const { return reference_element::T; }
	    friend std::ostream& operator << (std::ostream& os, const tetra& x) {
		return os << "T\t" << x._p[0] << " " << x._p[1] << " " << x._p[2] << " " << x._p[3]; }
	    size_type operator [] (size_type i) const { return _p[i]; }
	    size_type operator [] (size_type i) { return _p[i]; }
	    size_type dimension() const { return 3; }
	    size_type size() const { return 4; }
	    size_type _p[4];
	};
	struct triangle {
	    triangle () {}
	    triangle (size_type a, size_type b, size_type c)
		{ _p[0]=a; _p[1]=b; _p[2]=c; }
	    reference_element::enum_type type() const { return reference_element::t; }
	    friend std::ostream& operator << (std::ostream& os, const triangle& x) {
		return os << "t\t" << x._p[0] << " " << x._p[1] << " " << x._p[2]; }
	    size_type operator [] (size_type i) const { return _p[i]; }
	    size_type operator [] (size_type i) { return _p[i]; }
	    size_type dimension() const { return 2; }
	    size_type size() const { return 3; }
	    size_type _p[3];
	};
	struct edge {
	    edge () {}
	    edge (size_type a, size_type b)
		{ _p[0]=a; _p[1]=b; }
	    reference_element::enum_type type() const { return reference_element::e; }
	    friend std::ostream& operator << (std::ostream& os, const edge& x) {
		return os << "e\t" << x._p[0] << " " << x._p[1]; }
	    size_type operator [] (size_type i) const { return _p[i]; }
	    size_type operator [] (size_type i) { return _p[i]; }
	    size_type dimension() const { return 1; }
	    size_type size() const { return 2; }
	    size_type _p[2];
	};
	struct vertex {
	    vertex () {}
	    vertex (size_type a)
		{ _p[0]=a; }
	    reference_element::enum_type type() const { return reference_element::p; }
	    friend std::ostream& operator << (std::ostream& os, const vertex& x) {
		return os << "p\t" << x._p[0]; }
	    size_type operator [] (size_type i) const { return _p[i]; }
	    size_type operator [] (size_type i) { return _p[i]; }
	    size_type dimension() const { return 0; }
	    size_type size() const { return 1; }
	    size_type _p[1];
	};

  // modifier:

	// slist are in reverse order, by construction
	void reverse();

  // outputs:
	void put_geo(std::ostream& os);
	void dump(std::ostream& os = std::cerr);

  // data:
	size_type		_dim;
	std::map<size_type,point> _x;

	std::slist<std::slist<tetra> >    _T;
	std::slist<std::slist<triangle> > _t;
	std::slist<std::slist<edge> >     _e;
	std::slist<std::slist<vertex> >   _p;

	// domain names, by dimension
	std::slist<std::string>      _name_list [4];
};

std::istream& operator >> (std::istream& is, struct qmg& x);

}// namespace rheolef
#endif // _RHEO_GEO_QMG_H
