///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/form_element.h"
#include "mass.h"
#include "grad_grad.h"

namespace rheolef {
using namespace std;

template<class T>
form_element_rep<T>* 
form_element_rep<T>::make_ptr (
    string                name,
    const element<T>&     X,
    const element<T>&     Y,
    const geo_basic<T>&   omega)
{
  // TODO: use gperf instead of a long if-else test suite
  if (name == "")          return 0;
  if (name == "mass")      return new_macro (mass<T>(X,Y,omega));
  if (name == "grad_grad") return new_macro (grad_grad<T>(X,Y,omega));
  error_macro ("undefined form_element `" << name << "'");
  return 0;
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class form_element_rep<Float>;

} // namespace rheolef
