///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/grad_grad.h"

namespace rheolef {
using namespace std;
using namespace ublas;

template<class T>
void 
grad_grad<T>::operator() (const geo_element& K, ublas::matrix<T>& a) const
{
  build_scalar_grad_grad (K, a);
}
template<class T>
void
grad_grad<T>::initialize ()
{
    warning_macro ("call set_n_derivative...");
    this->set_n_derivative(2);
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class grad_grad<Float>;

} // namespace rheolef
