///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#ifdef _RHEOLEF_HAVE_MPI
// Note: this file is recursively included by "polymorphic_array_mpi.cc" 
// with growing "N" and in the namespace "rheolef"

/*F:
NAME: mpi_polymorphic_assembly_end -- polymorphic array assembly (@PACKAGE@ @VERSION@)
DESCRIPTION:
  Finish a dense polymorphic array assembly.
COMPLEXITY:
  **TO DO**
AUTHORS:
    LMC-IMAG, 38041 Grenoble cedex 9, France
    | Pierre.Saramito@imag.fr
DATE:   23 march 1999
END:
*/

//<mpi_polymorphic_assembly_end:
template <class Container, class Message>
struct mpi_polymorphic_assembly_end_t<Container,Message,N> {
  void operator() (
    // input:
        const distributor&	                       ownership,
        Message&                                       receive,	// buffer
        Message&                                       send, 	// buffer
        boost::array<typename Container::size_type,N>& receive_max_size,
    // output:
        Container&          		               x) const;
};


template <class Container, class Message>
void
mpi_polymorphic_assembly_end_t<Container,Message,N>::operator() (
    // input:
        const distributor&	                       ownership,
        Message&                                       receive,	// buffer
        Message&                                       send, 	// buffer
        boost::array<typename Container::size_type,N>& receive_max_size,
    // output:
        Container&          		               x) const
{
    typedef typename Container::size_type size_type;
    const size_type  _n_variant = Container::_n_variant; // should be = N
    // -----------------------------------------------------------------
    // 1) receive data and store it in container
    // -----------------------------------------------------------------
    // note: for wait_any, build an iterator adapter that scan the pair.second in [index,request]
    // and then get an iterator in the pair using iter.base(): retrive the corresponding index
    // for computing the position in the receive.data buffer
trace_macro ("msg_assembly_end...");
    typedef boost::transform_iterator<
		select2nd<size_type,mpi::request>, 
		typename std::list<std::pair<size_type,mpi::request> >::iterator>
            request_iterator;

#define _RHEOLEF_receive_data(z,k,unused)                            						\
    while (receive.waits[k].size() != 0) {									\
        typedef typename Container::T##k             T##k;							\
        typedef typename std::pair<size_type,T##k>   data##k##_type;						\
        request_iterator iter_r_waits (receive.waits[k].begin(), select2nd<size_type,mpi::request>()),		\
                         last_r_waits (receive.waits[k].end(),   select2nd<size_type,mpi::request>());		\
	/* waits on any receive... */										\
        std::pair<mpi::status,request_iterator> pair_status = mpi::wait_any (iter_r_waits, last_r_waits);	\
	/* check status */											\
	boost::optional<int> i_msg_size_opt = pair_status.first.template count<data##k##_type>();		\
	check_macro (i_msg_size_opt, "receive wait failed");							\
    	int iproc = pair_status.first.source();									\
	check_macro (iproc >= 0, "receive: source iproc = "<<iproc<<" < 0 !");					\
	/* get size of receive and number in data */								\
	size_type i_msg_size = (size_type)i_msg_size_opt.get();							\
        typename std::list<std::pair<size_type,mpi::request> >::iterator i_pair_ptr				\
	     = pair_status.second.base();									\
        size_type i_receive = (*i_pair_ptr).first;								\
        size_type i_start = i_receive*receive_max_size[k];							\
        for (size_type j = i_start; j < i_start + i_msg_size; j++) {						\
  	    size_type first_index = ownership.first_index();							\
            size_type index       = receive.data._stack_##k[j].first;						\
            T##k      value       = receive.data._stack_##k[j].second;						\
    	    x.assign (index - first_index, value);								\
        }													\
        receive.waits[k].erase (i_pair_ptr);									\
    }
    BOOST_PP_REPEAT(N, _RHEOLEF_receive_data, ~)
#undef _RHEOLEF_receive_data

#ifdef TODO
  size_type  start = ownership().first_index();					\
  size_type  last  = ownership().last_index();					\
  if (i_global >= start && i_global < last) 					\
    polymorphic_array_seq_rep<T,V,N>::assign (i_global - start, val);		\

#endif // TODO
    // -----------------------------------------------------------------
    // 2) wait on sends
    // -----------------------------------------------------------------
    for (size_type k = 0; k < _n_variant; k++) {
        request_iterator iter_s_waits (send.waits[k].begin(), select2nd<size_type,mpi::request>()),
                         last_s_waits (send.waits[k].end(),   select2nd<size_type,mpi::request>());
        size_type send_nproc = send.waits[k].size();
        std::vector<mpi::status> send_status (send_nproc);
        mpi::wait_all (iter_s_waits, last_s_waits, send_status.begin());
    }
    // -----------------------------------------------------------------
    // 3) clear send & receive messages [waits,data]
    // -----------------------------------------------------------------
#ifdef TODO
    send.waits.clear();
    send.data.clear();
    receive.waits.clear();
    receive.data.clear();
#endif // TODO
trace_macro ("msg_assembly_end done");
}
//>mpi_polymorphic_assembly_end:
#endif // _RHEOLEF_HAVE_MPI
