# $Id: NCAT.pm,v 2.9 2002/03/27 13:17:17 jallison Exp $
package NCAT;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

#
# $Log: NCAT.pm,v $
# Revision 2.9  2002/03/27 13:17:17  jallison
# commented out check for proper syntax/value in ParseRules to work with $(LOCAL_FOO) style variables
#
# Revision 2.8  2002/03/26 19:03:47  jnssf
# Changed variable declarations so that they remained package specific
# by defined globally using both 'EXPORT_OK' and 'use vars' definition.
# The former makes them available, the latter initializes them to be
# compliant with the 'use strict' command
#
# Revision 2.7  2002/03/21 16:36:35  gmj
# * housecleaning.  Export RuleClassesDefined.
#
# Revision 2.6  2002/03/20 10:43:21  gmj
# * Export global hashes for all rule classes (ConfigGlobal.*,
#   ConfigClass.*, ConfigLocal.*, Rule.*)
# * Added parsing for "ConfigClass.*" fields.
# * Added parsing for "ConfigLocal.*" fields.
# * Made use of lower-case indexes for hashes consistent.
#
# Revision 2.5  2002/03/17 20:07:20  gmj
# * Config parsing moved to common code in NCAT.pm
#
# Revision 2.4  2002/03/07 22:42:18  gmj
# * Backed out bogus change to version
#
# Revision 2.2  2002/03/04 18:56:25  gmj
# Incremented version for 1.1
#
# Revision 2.1  2002/01/24 21:51:15  gmj
# merge back to mainline
#
# Revision 2.0.2.1  2002/01/24 21:35:15  gmj
# Updated version to 1.0
#
# Revision 2.0  2001/12/21 15:23:36  gmj
# Level set version to 2.0 prior to branch for Center for Internet Security.
#
# Revision 1.5  2001/12/21 14:40:23  gmj
# update version to 0.94 for CIS initial release
#
# Revision 1.4  2001/12/20 08:02:31  gmj
# Update $VERSION to 0.93
#
# Revision 1.3  2001/12/14 11:32:11  gmj
# Updated VERSION to 0.92
#
# Revision 1.2  2001/12/11 21:44:12  jnssf
# Changes for allowing 'use NCAT;' to incorporate --version flag,
# misc changes to make code similar to other entries.  Change to NCAT.pm
# so it doesn't use bootstrapping, but instead a function call to ensure
# we no longer need the Auto/Dyna loader routines (which in the end weren't
# used anyway), to allow for the 'use' statements with the .ix or .so files.
#
# Revision 1.1.1.1  2001/11/14 21:40:19  gmj
# Initial CVS checkin.
#
#
# Revision 1.2  2001/11/14 16:40:02  gmj
# Updated for 0.9 rlease
#
#

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# @EXPORT = qw(
# );

@NCAT::EXPORT_OK = qw(
     &ParseRules
     %RuleFieldNames
     %RuleFieldValues
     %RulesDefined		
     %RuleClassesDefined
     %ConfigGlobalFieldNames
     %ConfigGlobalFieldValues
     %ConfigGlobalsDefined
     %ConfigClassFieldNames
     %ConfigClassFieldValues
     %ConfigClassClassesDefined
     %ConfigLocalFieldNames
     %ConfigLocalFieldValues
     %ConfigLocalsDefined
     @ConfigLines		
);

use vars qw(
     &ParseRules
     %RuleFieldNames
     %RuleFieldValues
     %RulesDefined		
     %RuleClassesDefined
     %ConfigGlobalFieldNames
     %ConfigGlobalFieldValues
     %ConfigGlobalsDefined
     %ConfigClassFieldNames
     %ConfigClassFieldValues
     %ConfigClassClassesDefined
     %ConfigLocalFieldNames
     %ConfigLocalFieldValues
     %ConfigLocalsDefined
     @ConfigLines		
);

$VERSION = '1.1';

sub Version { $VERSION };

# Preloaded methods go here.

sub addfile
{
    no strict 'refs';	# Countermand any strct refs in force so that we
			# can still handle file-handle names.

    my ($self, $handle) = @_;
    my ($package, $file, $line) = caller;
    my ($data) = '';

    if (!ref($handle))
    {
	# Old-style passing of filehandle by name. We need to add
	# the calling package scope qualifier, if there is not one
	# supplied already.

	$handle = $package . '::' . $handle unless ($handle =~ /(\:\:|\')/);
    }

    while (read($handle, $data, 1024))
    {
	$self->add($data);
    }
}


#
# The following set of code an variables have been added to allow
# simple code-reuse of the code that parses ncat.conf files.
#

# The following are filled in by RulesParse and are exported.
# In a perfect world, these would be encapsulated as part
# of an object definition.

#(%RuleFieldNames,
#     %RuleFieldValues,
#     %RulesDefined,
#     %RuleClassesDefined,
#     %ConfigGlobalFieldNames,
#     %ConfigGlobalFieldValues,
#     %ConfigGlobalsDefined,
#     %ConfigClassFieldNames,
#     %ConfigClassFieldValues,
#     %ConfigClassClassesDefined,
#     %ConfigLocalFieldNames,
#     %ConfigLocalFieldValues,
#     %ConfigLocalsDefined
#     ) = ((),(),(),(),(),(),(),(),(),(),(),(),());

(@ConfigLines) = ();

#
# Rules
#


# Define rules field names and acceptable syntax for attribute values

$RuleFieldNames{"rulename"}        = '\\w[\\w\\s\\-]+';
$RuleFieldNames{"ruleversion"}     = '.*';
$RuleFieldNames{"rulecontext"}     = '(Global|IOSInterface|IOSLine)';
$RuleFieldNames{"ruleinstance"}    = '.*';
$RuleFieldNames{"ruleclass"}       = '\\w[\\w\\s,\\-]+';
$RuleFieldNames{"ruletype"}        = '(Required|Forbidden)';
$RuleFieldNames{"rulematch"}       = '.*';
$RuleFieldNames{"ruleimportance"}  = '\\d+';
$RuleFieldNames{"ruledescription"} = '.*';
$RuleFieldNames{"rulefix"} = ".*";

# Define list of required fields for each rule that is defined

my @RequiredRuleFields = ("rulename","rulecontext","ruleclass","ruleversion","rulematch","ruletype","ruleimportance");

%RulesDefined = ();
%RuleClassesDefined = ();

#
# Config Globals
#

# Define global definition field names and acceptable syntax for attribute values

$ConfigGlobalFieldNames{"configversion"} = "[\\d\.]+";
$ConfigGlobalFieldNames{"configorganization"} = ".*";
$ConfigGlobalFieldNames{"configdocumenttype"} = ".*";
$ConfigGlobalFieldNames{"configplatforms"} = ".*";
$ConfigGlobalFieldNames{"configfeedbackto"} = ".*";
$ConfigGlobalFieldNames{"configintrotext"} = ".*";
$ConfigGlobalFieldNames{"configtrailingtext"} = ".*";
$ConfigGlobalFieldNames{"configguidepath"} = ".*";
$ConfigGlobalFieldNames{"configguide"} = ".*"; # no default
$ConfigGlobalFieldNames{"configrulesalias"} = ".*"; # no default
$ConfigGlobalFieldNames{"configoutputgroups"} = ".*"; # no default

# define ConfigLineSkip ...this allows you to specify strings
# (passwd style list) that are matched against the text of Cisco IOS line configuration
# definitions.  If the string matches, then checking of the line definition is skipped.
# This is IOS specific and should be split out into a generic config parsing module.
# There should also be a corresponding list for Global and VTY definitions. --gmj 3/4/02

$ConfigGlobalFieldNames{"configlineskip"} = ".*"; # no default

# default values

$ConfigGlobalFieldValues{"configversion"} = "0.0";
$ConfigGlobalFieldValues{"configorganization"} = "Local Organization Name";
$ConfigGlobalFieldValues{"configdocumenttype"} = "Security Audit Rules";
$ConfigGlobalFieldValues{"configplatforms"} = "Cisco IOS Routers";
$ConfigGlobalFieldValues{"configintrotext"} = "Intro";
$ConfigGlobalFieldValues{"configtrailingtext"} = "Closing";
$ConfigGlobalFieldValues{"configrulesalias"} = "rat_rules.html";

# See comment on $ConfigGlobalFieldNames{"configlineskip"}
$ConfigGlobalFieldValues{"configlineskip"} = "^ shutdown";

%ConfigGlobalsDefined = ();

#
# ConfigLocal Options
#


#
# ConfigClass Options
#

$ConfigClassFieldNames{"configclass"}			= '\\w[\\w\\s\\-]+';
$ConfigClassFieldNames{"configclassconflictswith"}	= '\\w[\\w\\s,\\-]+';
$ConfigClassFieldNames{"configclassprereq"}		= '\\w[\\w\\s,\\-]+';
$ConfigClassFieldNames{"configclassdescription"}	= '.*';

%ConfigClassClassesDefined = ();


#
# ConfigLocal Options
#

$ConfigLocalFieldNames{"configlocalname"}		= '\\w[\\w\\s\\-]+';
$ConfigLocalFieldNames{"configlocalvalue"}		= '.*';
$ConfigLocalFieldNames{"configlocalclassprereq"}	= '\\w[\\w\\s,\\-]+';
$ConfigLocalFieldNames{"configlocaldescription"}	= '.*';

%ConfigLocalsDefined = ();

# Define list of required fields for each rule that is defined

my @RequiredConfigLocalFields = ("configlocalvalue");


#
# Parse the rules file $RulesName.  Permttted keywords and regexps to
# define the values are passed in via %RuleFieldNames  Results are
# Stored in %RulesDefined and %RuleFieldValues.

sub ParseRules {
  my($RulesName) = @_;
  my($CurrentRuleName,
     $CurrentClassName,
     $CurrentLocalName,
     $text,
     $text_lc,
     $keyword,
     $keyword_lc,
     $line,
     $required,
     $name,$class) =
	 ("", "", "", "", "","","","","","");
  
  my($lineno) = 0;
  my(@Classes) = ();


  #
  # In the finest perl style, slurp in the whole config file
  # and parse out the rules
  # 

  open(RULES,"<$RulesName") || die "Can't open $RulesName for reading: $!";
  while(<RULES>) {
      
      $line = $_;
      $lineno++;

      s/\s+$//; # strip trailing blanks
      chomp;
      push @ConfigLines,$_;  # save (nearly) raw config lines
      
      next if (/^\s*[#!]/); # skip lines with leading comments

      if (/^\s*$/) {
	  $CurrentRuleName = ""; # blank line ends RuleName record
	  $CurrentClassName = ""; # blank line ends ConfigClass record
	  $CurrentLocalName = ""; # blank line ends ConfigClass record
	  next; # skip blank lines
      } 

      s/^\s*[#!].*//; # strip trailing comments      
  


    # Parse Interesting lines and save them

    if (/^\s*(\w+):(.*)/) {
	$keyword = $1;
	$text = defined($2) ? $2 : "";

	# store lower case versions.  These are used for
	# call comparison, hash indexes, etc.  The non-downcased
	# version are used for display.

	$keyword_lc = lc($keyword);  

	# handle continuation lines
	
	while ($text =~ /\\$/s) {
	    $text =~ s/\n$//s;
	    $text =~ s/\\$/\n/s;
	    $_ = <RULES> || last;
	    $lineno++;
	    $text .= $_;
	}

	$text_lc = lc($text);
	
	if (defined($ConfigGlobalFieldNames{$keyword_lc})) {

	    # Save config global values
	    
	    die("Bad value for ConfigGlobalFieldNames $keyword. /$text/ does not match /^$ConfigGlobalFieldNames{$keyword}\$/")
		unless ($text_lc =~ /^$ConfigGlobalFieldNames{$keyword_lc}$/si);
	    
	    $ConfigGlobalsDefined{"$keyword_lc"} = $ConfigGlobalFieldValues{"$keyword_lc"} = "$text";
	    
	    
	} elsif (defined($RuleFieldNames{$keyword_lc})) {
   
	    # Save the rule name and attribute
	    
	    if ($keyword_lc =~ /RuleName/i) {
		die("Rule /$text/ already defined") if defined $RulesDefined{$text_lc};
		$CurrentRuleName = $text_lc;
		$RulesDefined{$CurrentRuleName} = $text; # index lowercase, value retains case
	    }

	    # Save rule classes individually
	    
	    if ($keyword_lc =~ /RuleClass/i) {
		@Classes = split(/\s*,\s*/,$text_lc);

		foreach $class (@Classes) {
		    $RuleFieldValues{"$CurrentRuleName:$keyword_lc:$class"} = $class;
		    $RuleClassesDefined{$class} = $class;
		}
	    }

	    # Save each field value
	    
	    $RuleFieldValues{"$CurrentRuleName:$keyword_lc"} = $text;
	    print STDERR "RuleFieldValues{$CurrentRuleName:$keyword_lc} = $text\n" if ($main::opt_debug =~ /rulevalues/i);
	    
	    # die if text does not have proper syntax/value
	    
#	    die("Bad value for rule $CurrentRuleName, field $keyword. /$text/ does not match /^$RuleFieldNames{$keyword}\$/")
#		unless ($text =~ /^$RuleFieldNames{$keyword_lc}$/si);
	    
	    print STDERR "rule: /$CurrentRuleName/, keyword: /$keyword/, text: /$text/\n" if ($main::opt_debug =~ /config/i);

	} elsif (defined($ConfigClassFieldNames{$keyword_lc})) {
	    
	    # Save the class name and attribute
	    
	    if ($keyword =~ /ConfigClass$/i) {
		$CurrentClassName = $text_lc;
		die("Class /$CurrentClassName/ already defined") if defined $ConfigClassClassesDefined{$CurrentClassName};
		$ConfigClassClassesDefined{$CurrentClassName} = "$text";
	    }
	    
	    $ConfigClassFieldValues{"$CurrentClassName:$keyword_lc"} = $text;
	    print STDERR "ConfigClassFieldValues{$CurrentClassName:$keyword_lc} = $text\n" if ($main::opt_debug =~ /configvalues/i);
	    
	    # die if text does not have proper syntax/value
	    
	    die("Bad value for class $CurrentClassName, field $keyword. /$text/ does not match /^$ConfigClassFieldNames{$keyword_lc}\$/")
		unless ($text =~ /^$ConfigClassFieldNames{$keyword_lc}$/si);
	    
	    print STDERR "rule: /$CurrentClassName/, keyword: /$keyword/, text: /$text/\n" if ($main::opt_debug =~ /config/i);

	} elsif (defined($ConfigLocalFieldNames{$keyword_lc})) {

	    # Save the local name and attribute
	    
	    if ($keyword =~ /ConfigLocalName/i) {
		$CurrentLocalName = $text_lc;
		die("Local /$CurrentLocalName/ already defined") if defined $ConfigLocalsDefined{$CurrentLocalName};
		$ConfigLocalsDefined{$CurrentLocalName} = "$text";
	    }
	    
	    $ConfigLocalFieldValues{"$CurrentLocalName:$keyword_lc"} = $text;
	    print STDERR "ConfigLocalFieldValues{$CurrentLocalName:$keyword_lc} = $text\n" if ($main::opt_debug =~ /configvalues/i);
	    
	    # die if text does not have proper syntax/value
	    
	    die("Bad value for local  $CurrentLocalName, field $keyword. /$text/ does not match /^$ConfigLocalFieldNames{$keyword_lc}\$/")
		unless ($text =~ /^$ConfigLocalFieldNames{$keyword_lc}$/si);
	    
	    print STDERR "local: /$CurrentLocalName/, keyword: /$keyword/, text: /$text/\n" if ($main::opt_debug =~ /config/i);

	} else {
	    die("unknown rules file keyword /$keyword/");
	}

    } else {
	warn "skipping line $lineno in $RulesName. Bad Format.\n/$line/";
    }
	     
  } # for all lines in the rules config

  # 
  # Check for required attributes for each rule
  #
		   
  foreach $name (keys %RulesDefined) {
      foreach $required (@RequiredRuleFields) {
	  die "Required attribute /$required/ not defined for rule /$name/"
	    unless (defined $RuleFieldValues{"$name:$required"})
	}
  }

  close(RULES);
}



1;

__END__
