//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  GEOM PARTITION : partition algorithm
//  File   : Partition_Spliter.hxx
//  Module : GEOM
//
#ifndef _Partition_Spliter_HeaderFile
#define _Partition_Spliter_HeaderFile

#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _TopoDS_Compound_HeaderFile
#include <TopoDS_Compound.hxx>
#endif
#ifndef _BRep_Builder_HeaderFile
#include <BRep_Builder.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _TopTools_MapOfShape_HeaderFile
#include <TopTools_MapOfShape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _Handle_BRepAlgo_AsDes_HeaderFile
#include <Handle_BRepAlgo_AsDes.hxx>
#endif
#ifndef _BRepAlgo_Image_HeaderFile
#include <BRepAlgo_Image.hxx>
#endif
#ifndef _Partition_Inter3d_HeaderFile
#include "Partition_Inter3d.hxx"
#endif
#ifndef _TopTools_MapOfOrientedShape_HeaderFile
#include <TopTools_MapOfOrientedShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BRepAlgo_AsDes;
class TopoDS_Shape;
class TopTools_ListOfShape;
class TopoDS_Edge;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

class Partition_Spliter  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
Standard_EXPORT Partition_Spliter();
Standard_EXPORT   void AddShape(const TopoDS_Shape& S) ;
Standard_EXPORT   void AddTool(const TopoDS_Shape& S) ;
Standard_EXPORT   void Compute(const TopAbs_ShapeEnum Limit = TopAbs_SHAPE) ;
Standard_EXPORT   void KeepShapesInside(const TopoDS_Shape& S) ;
Standard_EXPORT   void RemoveShapesInside(const TopoDS_Shape& S) ;
Standard_EXPORT   TopoDS_Shape Shape() const;
Standard_EXPORT   void Clear() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 
Standard_EXPORT   void MakeSolids(const TopoDS_Shape& Solid,TopTools_ListOfShape& Shells) ;
Standard_EXPORT   void MakeShells(const TopoDS_Shape& S,TopTools_ListOfShape& NS) ;
Standard_EXPORT   TopoDS_Shape MakeFaces(const TopoDS_Shape& S) ;
Standard_EXPORT   void MakeEdges(const TopoDS_Edge& E,const TopTools_ListOfShape& VOnE,TopTools_ListOfShape& NE) const;
Standard_EXPORT   TopoDS_Shape FindFacesInside(const TopoDS_Shape& S,const Standard_Boolean CheckClosed = Standard_False,const Standard_Boolean All = Standard_False) ;
Standard_EXPORT   Standard_Boolean CheckTool(const TopoDS_Shape& S) ;
Standard_EXPORT   void MergeEqualEdges(const TopTools_ListOfShape& LE) ;
Standard_EXPORT static  Standard_Boolean IsInside(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;
Standard_EXPORT   TopoDS_Shape GetOriginalShape(const TopoDS_Shape& aShape) const;
Standard_EXPORT   void FindToolsToReconstruct() ;


 // Fields PRIVATE
 //
TopAbs_ShapeEnum myDoneStep;
TopoDS_Compound myShape;
BRep_Builder myBuilder;
TopTools_ListOfShape myListShapes;
TopTools_MapOfShape myMapFaces;
TopTools_MapOfShape myMapTools;
TopTools_MapOfShape myEqualEdges;
TopTools_MapOfShape myNewSection;
TopTools_MapOfShape myClosedShapes;
TopTools_MapOfShape mySharedFaces;
TopTools_MapOfShape myWrappingSolid;
TopTools_DataMapOfShapeShape myFaceShapeMap;
TopTools_DataMapOfShapeShape myInternalFaces;
TopTools_DataMapOfShapeShape myIntNotClFaces;
Handle_BRepAlgo_AsDes myAsDes;
BRepAlgo_Image myImagesFaces;
BRepAlgo_Image myImagesEdges;
BRepAlgo_Image myImageShape;
Partition_Inter3d myInter3d;
TopTools_MapOfOrientedShape myAddedFacesMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
