//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
// File:      QtxAction.h
// Author:    Sergey TELKOV
//
#ifndef QTXACTION_H
#define QTXACTION_H

#include "Qtx.h"

#include <QWidgetAction>

class QIcon;

#ifdef WIN32
#pragma warning ( disable:4251 )
#endif

class QTX_EXPORT QtxAction : public QWidgetAction
{
  Q_OBJECT

  class ActionNotify;

public:
  QtxAction( QObject* = 0, bool = false );
  QtxAction( const QString&, const QString&, int, QObject*, bool = false );
  QtxAction( const QString&, const QIcon&, const QString&, int, QObject*, bool = false );
  virtual ~QtxAction();

  virtual bool eventFilter( QObject*, QEvent* );

protected:
  virtual void addedTo( QWidget* );
  virtual void removedFrom( QWidget* );

  virtual void customEvent( QEvent* );
};

#ifdef WIN32
#pragma warning ( default:4251 )
#endif

#endif
