//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  File   : VisuGUI_SelectionPrefDlg.cxx
//  Author : Oleg UVAROV
//  Module : SALOME
//
#ifndef VisuGUI_SELECTIONPREFDLG_H
#define VisuGUI_SELECTIONPREFDLG_H

#include <QDialog>

class QComboBox;
class QGroupBox;
class QPushButton;

class QtxColorButton;
class QtxDoubleSpinBox;
class QtxIntSpinBox;

class VisuGUI_SelectionPrefDlg : public QDialog
{ 
  Q_OBJECT

public:
  VisuGUI_SelectionPrefDlg( QWidget* parent = 0 );
  ~VisuGUI_SelectionPrefDlg();
    
public:
  void                      update();

private:
  void                      keyPressEvent( QKeyEvent* e );
    
protected slots:
  void                      accept();

  void                      onApply();
  void                      onHelp();
  
private:
  QtxDoubleSpinBox*         myCursorSizeSpinBox;
  QtxDoubleSpinBox*         myPyramidHeightSpinBox;
  QtxColorButton*           mySelectionColorButton;
  QtxDoubleSpinBox*         myPointToleranceSpinBox;

  QGroupBox*                myInfoWindowGroup;
  QtxIntSpinBox*            myTransparencySpinBox;
  QComboBox*                myPositionComboBox;

  QGroupBox*                myCameraGroup;
  QtxDoubleSpinBox*         myZoomFactorSpinBox;
  QtxIntSpinBox*            myStepNumberSpinBox;

  QPushButton*              myButtonOk;
  QPushButton*              myButtonApply;
  QPushButton*              myButtonCancel;
  QPushButton*              myButtonHelp;
};

#endif // VisuGUI_SELECTIONPREFDLG_H
