//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  VISU OBJECT : interactive object for VISU entities implementation
//  File   : VISU_Prs3dUtils.cc
//  Author : Alexey PETROV
//  Module : VISU
//
#include "VISU_Prs3dUtils.hh"
#include "SalomeApp_Study.h"
#include "SALOME_Event.h"


namespace VISU
{
  //----------------------------------------------------------------------------
  TSetModified
  ::TSetModified(VISU::Prs3d_i* thePrs3d):
    myPrs3d(thePrs3d)
  {
    this->Modified();
  }


  //----------------------------------------------------------------------------
  TSetModified
  ::~TSetModified()
  {
    struct TEvent: public SALOME_Event
    {
      VISU::TSetModified* mySetModified;
      TEvent(VISU::TSetModified* theSetModified):
	mySetModified(theSetModified)
      {}
    
      virtual
      void
      Execute()
      {
	VISU::Prs3d_i* aPrs3d = mySetModified->myPrs3d;

	if(!aPrs3d || aPrs3d->GetActorEntry() == "")
	  return;
	
	if(aPrs3d->GetMTime() > mySetModified->GetMTime()){
	  if(SalomeApp_Study* aStudy = aPrs3d->GetGUIStudy())
	    aStudy->Modified();
	}
      }
    };

    ProcessVoidEvent(new TEvent(this));
  }

  //----------------------------------------------------------------------------

  std::string ToFormat( const int thePrec )
  {
    // "%-#6.3g"
    char str[ 255 ];
    sprintf( str, "%%-#.%dg", thePrec );
    return str;
  }

  //----------------------------------------------------------------------------

  int ToPrecision( const char* theFormat )
  {
    int N = strlen( theFormat );
    int k = -1;
    char str[ 255 ];
    bool isOk = false;
    for ( int i = 0; i < N; i++ )
    {
      if ( theFormat[ i ] ==  '.' )
        k = 0;
      else if ( theFormat[ i ] == 'g' )
      {
        str[ k ] = 0;
        isOk = true;
        break;
      }
      else if ( k >= 0 )
        str[ k++ ] = theFormat[ i ];
    }

    int res = 0;
    if ( isOk )
      res = atoi( str );

    return res;
  }
};

















