//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  SALOME VTKViewer : build VTK viewer into Salome desktop
//  File   : VVTK_InteractorStyle.h
//  Author : Christophe ATTANASIO
//  Module : SALOME
//  $Header$
//
#ifndef __VVTK_InteractorStyle_h
#define __VVTK_InteractorStyle_h


#include "VVTK.h"

#include "SVTK_InteractorStyle.h"
//
//-------------------------------------------
//! Control the value of increment in new style of interaction.
/*!
  This class controls of value of increment,
  for pan/rotate/zoom operations in new style 
  of interaction
*/
class VVTK_ControllerIncrement : public SVTK_ControllerIncrement {
 public:
  vtkTypeMacro(VVTK_ControllerIncrement,SVTK_ControllerIncrement);
  static VVTK_ControllerIncrement* New();
  
  //! Increace the increment value by multiplying on 2
  virtual int Increase();

  //! Decreace the increment value by division on 2
  virtual int Decrease();
  
 protected:
  VVTK_ControllerIncrement();
  virtual ~VVTK_ControllerIncrement();
  //
 private:
  VVTK_ControllerIncrement(const VVTK_ControllerIncrement&);  //Not implemented
  void operator=(const VVTK_ControllerIncrement&);  //Not implemented
};
//
//-------------------------------------------
//! Control the behaviour of KeyDown event in new style of interaction.
/*!
  This class controls of behaviour of of KeyDown event
  in new style of interaction.
*/
class VVTK_ControllerOnKeyDown : public SVTK_ControllerOnKeyDown{
 public:
  vtkTypeMacro(VVTK_ControllerOnKeyDown, SVTK_ControllerOnKeyDown);
  static VVTK_ControllerOnKeyDown* New();

  //! Provides the action on event 
  virtual bool OnKeyDown(vtkInteractorStyle* );

 protected:
  VVTK_ControllerOnKeyDown();
  virtual ~VVTK_ControllerOnKeyDown();
  
 private:
  VVTK_ControllerOnKeyDown(const VVTK_ControllerOnKeyDown&);//Not implemented
  void operator=(const VVTK_ControllerOnKeyDown&);          //Not implemented
};


//! Introduce new style of interaction (keyboard free)
class VVTK_EXPORT VVTK_InteractorStyle : public SVTK_InteractorStyle
{
 public:
  static VVTK_InteractorStyle *New();
  vtkTypeMacro(VVTK_InteractorStyle,SVTK_InteractorStyle);

  //! Redefined from SVTK_InteractorStyle::SetInteractor in order to add an observer (callback) for custorm event (space mouse event)
  virtual
  void
  SetInteractor( vtkRenderWindowInteractor* );
  
 protected:
  VVTK_InteractorStyle();
  ~VVTK_InteractorStyle();

  VVTK_InteractorStyle(const VVTK_InteractorStyle&); // Not implemented
  void operator=(const VVTK_InteractorStyle&); // Not implemented

  // Generic event bindings must be overridden in subclasses

  //! Redefine SVTK_InteractorStyle::OnLeftButtonDown
  virtual void OnLeftButtonDown(int ctrl, int shift, int x, int y);

  //! Redefine SVTK_InteractorStyle::OnMiddleButtonDown
  virtual void OnMiddleButtonDown(int ctrl, int shift, int x, int y);

  //! Redefine SVTK_InteractorStyle::OnLeftButtonUp
  virtual void OnLeftButtonUp(int ctrl, int shift, int x, int y);

  //! Redefine SVTK_InteractorStyle::OnMiddleButtonUp
  virtual void OnMiddleButtonUp(int ctrl, int shift, int x, int y);

  //! Redefine SVTK_InteractorStyle::onFinishOperation
  virtual void onFinishOperation();

  //! Main process VTK event method
  static 
  void
  ProcessEvents(vtkObject* object, 
		unsigned long event,
		void* clientData, 
		void* callData );

  //! Redefine SVTK_InteractorStyle::onSpaceMouseButton
  virtual void onSpaceMouseButton( int button );
  
  //! To decrease magnification of the Gauss Points
  void DecreaseGaussPointMagnification();

  //! To increase magnification of the Gauss Points
  void IncreaseGaussPointMagnification();

  //! SpaceMouse short cuts
  int mySMDecreaseMagnificationBtn;
  int mySMIncreaseMagnificationBtn;
  
  bool myIsMidButtonDown;
  bool myIsLeftButtonDown;
};

#endif
