//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  SALOME OBJECT : implementation of interactive object visualization for OCC and VTK viewers
//  File   : 
//  Author : 
//  Module : 
//  $Header$
//
#include "VVTK_MainWindow.h"
#include "VVTK_InteractorStyle.h"
#include "VVTK_Recorder.h"
#include "VVTK_RecorderDlg.h"
#include "VISU_WidgetCtrl.hxx"
#include "VISU_GaussPtsAct.h"
#include "VISU_Event.h" 

#include "SVTK_ViewWindow.h"
#include "SVTK_RenderWindowInteractor.h"
#include "VVTK_Renderer.h"
#include "VVTK_PickingDlg.h"
#include "VVTK_SegmentationCursorDlg.h"

#include "SUIT_Application.h"
#include "SUIT_Session.h"
#include "SUIT_Tools.h"
#include "SUIT_ViewWindow.h"
#include "SUIT_ResourceMgr.h"
#include "SUIT_Accel.h"
#include "SUIT_MessageBox.h"
#include "QtxAction.h"
#include "QtxMultiAction.h"
#include "QtxActionToolMgr.h"

#include <QImage>
#include <QToolBar>
#include <QSplitter>
#include <QFileDialog>
#include <QApplication>

//----------------------------------------------------------------------------
VVTK_MainWindow::VVTK_MainWindow(QWidget* theParent, 
				 const char* theName,
				 SUIT_ResourceMgr* theResourceMgr,
				 SUIT_ViewWindow* theViewWindow):
  SVTK_MainWindow(theParent,theName,theResourceMgr,theViewWindow),
  myControllerIncrement(VVTK_ControllerIncrement::New()),
  myControllerOnKeyDown(VVTK_ControllerOnKeyDown::New())
{
  myToolMgr = new QtxActionToolMgr( this );

  myControllerIncrement->Delete();
  myControllerOnKeyDown->Delete();

  // Recording
  myRecordingToolBar = new QToolBar(tr("LBL_TOOLBAR_RECORD_LABEL"), this);
  addToolBar(Qt::LeftToolBarArea, myRecordingToolBar );
  myViewWindow->toolMgr()->remove( NonIsometric, myToolBar );
  

  myStartAction = new QtxAction(tr("MNU_VVTK_RECORDING_START"), 
				theResourceMgr->loadPixmap( "VISU", tr( "ICON_VVTK_RECORDING_START" ) ),
				tr( "MNU_VVTK_RECORDING_START" ), 0, this);
  myStartAction->setStatusTip(tr("DSC_VVTK_RECORDING_START"));
  //myStartAction->addTo( myRecordingToolBar );
  myRecordingToolBar->addAction( myStartAction  );
  connect( myStartAction, SIGNAL( triggered ( bool ) ), this, SLOT( OnStartRecording() ) );

  myPlayAction = new QtxAction(tr("MNU_VVTK_RECORDING_PLAY"), 
			       theResourceMgr->loadPixmap( "VISU", tr( "ICON_VVTK_RECORDING_PLAY" ) ),
			       tr( "MNU_VVTK_RECORDING_PLAY" ), 0, this);
  myPlayAction->setStatusTip(tr("DSC_VVTK_RECORDING_PLAY"));
  myPlayAction->setEnabled( false );
  //myPlayAction->addTo( myRecordingToolBar );
  myRecordingToolBar->addAction( myPlayAction  );
  connect( myPlayAction, SIGNAL( triggered ( bool ) ), this, SLOT( OnPlayRecording() ) );

  myPauseAction = new QtxAction(tr("MNU_VVTK_RECORDING_PAUSE"), 
				theResourceMgr->loadPixmap( "VISU", tr( "ICON_VVTK_RECORDING_PAUSE" ) ),
				tr( "MNU_VVTK_RECORDING_PAUSE" ), 0, this);
  myPauseAction->setStatusTip(tr("DSC_VVTK_RECORDING_PAUSE"));
  myPauseAction->setEnabled( false );
  //myPauseAction->addTo( myRecordingToolBar );
  myRecordingToolBar->addAction( myPauseAction  );
  connect( myPauseAction, SIGNAL( triggered ( bool ) ), this, SLOT( OnPauseRecording() ) );

  myStopAction = new QtxAction(tr("MNU_VVTK_RECORDING_STOP"), 
			       theResourceMgr->loadPixmap( "VISU", tr( "ICON_VVTK_RECORDING_STOP" ) ),
			       tr( "MNU_VVTK_RECORDING_STOP" ), 0, this);
  myStopAction->setStatusTip(tr("DSC_VVTK_RECORDING_STOP"));
  myStopAction->setEnabled( false );
  //myStopAction->addTo( myRecordingToolBar );
  myRecordingToolBar->addAction( myStopAction  );
  connect( myStopAction, SIGNAL( triggered ( bool ) ), this, SLOT( OnStopRecording() ) );
  
  myRecorder = VVTK_Recorder::New();
  //myRecorder->CheckExistAVIMaker();
  //if(myRecorder->ErrorStatus())
  //  myRecordingToolBar->setEnabled(false);
}

//----------------------------------------------------------------------------

QtxActionToolMgr* VVTK_MainWindow::toolMgr() const
{
  return myToolMgr;
}

//----------------------------------------------------------------------------
void VVTK_MainWindow::Initialize(SVTK_RenderWindowInteractor* theInteractor)
{ 
  vtkInteractorStyle* aStyle = theInteractor->GetInteractorStyle();
  if(SVTK_InteractorStyle *anInteractorStyle = dynamic_cast<SVTK_InteractorStyle*>(aStyle)){
    anInteractorStyle->SetControllerIncrement(myControllerIncrement.GetPointer());
    anInteractorStyle->SetControllerOnKeyDown(myControllerOnKeyDown.GetPointer());
  }

  myRecorder->SetNbFPS(17.3);
  myRecorder->SetQuality(100);
  myRecorder->SetProgressiveMode(true);
  myRecorder->SetUseSkippedFrames(true);
  myRecorder->SetRenderWindow(theInteractor->getRenderWindow());

  disconnect( SVTK_MainWindow::action( DumpId ), SIGNAL( activated() ),
	      myViewWindow, SLOT( onDumpView() ) );

  connect( SVTK_MainWindow::action( DumpId ), SIGNAL( activated() ),
	   this, SLOT( onDumpView() ) );

  SVTK_MainWindow::Initialize(theInteractor);
  addToolBar( Qt::LeftToolBarArea, getToolBar() );
}

VVTK_MainWindow::~VVTK_MainWindow()
{
  if(myRecorder)
    myRecorder->Delete();
}

//----------------------------------------------------------------------------
void VVTK_MainWindow::onDumpView()
{
  QImage img = dumpView();
  if( img.isNull() )
    return; 

  SUIT_Application* app = SUIT_Session::session()->activeApplication();
  QString fileName = app->getFileName( false, QString::null,
				       tr( "TLT_IMAGE_FILES" ),
				       tr( "TLT_DUMP_VIEW" ), 0 );
  if( fileName.isEmpty() )
    return;

  QString fmt = SUIT_Tools::extension( fileName ).toUpper();
  if( fmt.isEmpty() )
    fmt = QString( "BMP" ); // default format
  else if( fmt == "JPG" )
    fmt = "JPEG";

  QApplication::setOverrideCursor( Qt::WaitCursor );
  img.save( fileName, fmt.toLatin1() );
  QApplication::restoreOverrideCursor();
}

//----------------------------------------------------------------------------
void VVTK_MainWindow::OnStartRecording()
{
  myRecorder->CheckExistAVIMaker();
  if (myRecorder->ErrorStatus()) {
    SUIT_MessageBox::warning(this, tr("ERROR"), tr("MSG_NO_AVI_MAKER") );
  }
  else {
    VVTK_RecorderDlg* aRecorderDlg = new VVTK_RecorderDlg( this, myRecorder );

    if( !aRecorderDlg->exec() )
      return;

    myStartAction->setEnabled( false );
    myPlayAction->setEnabled( false );
    myPauseAction->setEnabled( true );
    myStopAction->setEnabled( true );

    myRecorder->Record();
  }
}

//----------------------------------------------------------------------------
void VVTK_MainWindow::OnPlayRecording()
{
  myStartAction->setEnabled( false );
  myPlayAction->setEnabled( false );
  myPauseAction->setEnabled( true );
  myStopAction->setEnabled( true );
  //
  myRecorder->Pause();
}

//----------------------------------------------------------------------------
void VVTK_MainWindow::OnPauseRecording()
{
  myStartAction->setEnabled( false );
  myPlayAction->setEnabled( true );
  myPauseAction->setEnabled( false );
  myStopAction->setEnabled( true );
  //
  myRecorder->Pause();
}

//----------------------------------------------------------------------------
void VVTK_MainWindow::OnStopRecording()
{
  myStartAction->setEnabled( true );
  myPlayAction->setEnabled( false );
  myPauseAction->setEnabled( false );
  myStopAction->setEnabled( false );
  //
  myRecorder->Stop();
}

//----------------------------------------------------------------------------
void VVTK_MainWindow::action( const int accelAction  )
{
  if ( accelAction == SUIT_Accel::ZoomFit )
    onFitAll();
  else {
    int anEvent = SVTK::convertAction( accelAction );
    InvokeEvent( anEvent, 0 );
  }
}

//----------------------------------------------------------------------------
VVTK_MainWindow1::VVTK_MainWindow1(QSplitter* theParent, 
				   const char* theName,
				   SUIT_ResourceMgr* theResourceMgr,
				   SUIT_ViewWindow* theViewWindow):
  VVTK_MainWindow(theParent,theName,theResourceMgr,theViewWindow),
  mySplitter(theParent),
  myPickingDlg(NULL)
{
  myPtsToolBar = new QToolBar( tr("LBL_TOOLBAR_GAUSS_LABEL"), this );
  addToolBar( Qt::LeftToolBarArea, myPtsToolBar );

  QPixmap aPixmap;
  QtxAction* anAction;

  aPixmap = theResourceMgr->loadPixmap("VISU",tr("ICON_VVTK_SELECTION_MODE_SWITCH"));
  myPickingAction = new QtxAction(tr("MNU_VVTK_SELECTION_MODE_SWITCH"), 
				  aPixmap,
				  tr( "MNU_VVTK_SELECTION_MODE_SWITCH" ), 
				  0, 
				  this, 
				  //"VVTK/SVTK SelectionSwitch", 
				  true);
  myPickingAction->setCheckable(true);
  myPickingAction->setStatusTip(tr("DSC_VVTK_SELECTION_MODE_SWITCH"));
  myPtsToolBar->addAction( myPickingAction );
  connect(myPickingAction, SIGNAL(toggled(bool)), this, SLOT(OnSelectionModeSwitch(bool)));

  myPickingDlg = new VVTK_PickingDlg( myPickingAction, this, "PickingDlg" );

  // Plane/Sphere Segmentation
  aPixmap = theResourceMgr->loadPixmap("VISU",tr("ICON_VVTK_PLANE_SEGMENTATION_SWITCH"));
  myPlaneSegmentationAction = new QtxAction(tr("MNU_VVTK_PLANE_SEGMENTATION_SWITCH"), 
					    aPixmap,
					    tr( "MNU_VVTK_PLANE_SEGMENTATION_SWITCH" ), 
					    0, 
					    this, 
					    //"VVTK/SVTK PlaneSegmentationSwitch", 
					    true);
  myPlaneSegmentationAction->setCheckable(true);
  myPlaneSegmentationAction->setStatusTip(tr("DSC_VVTK_PLANE_SEGMENTATION_SWITCH"));
  //myPlaneSegmentationAction->addTo( myPtsToolBar );
  connect( myPlaneSegmentationAction, SIGNAL( triggered() ), this, SLOT( OnSegmentationSwitch() ) );

  aPixmap = theResourceMgr->loadPixmap("VISU",tr("ICON_VVTK_SPHERE_SEGMENTATION_SWITCH"));
  mySphereSegmentationAction = new QtxAction(tr("MNU_VVTK_SPHERE_SEGMENTATION_SWITCH"), 
					     aPixmap,
					     tr( "MNU_VVTK_SPHERE_SEGMENTATION_SWITCH" ), 
					     0, 
					     this, 
					     //"VVTK/SVTK SphereSegmentationSwitch", 
					     true);
  mySphereSegmentationAction->setCheckable(true);
  mySphereSegmentationAction->setStatusTip(tr("DSC_VVTK_SPHERE_SEGMENTATION_SWITCH"));
  //mySphereSegmentationAction->addTo( myPtsToolBar );
  connect( mySphereSegmentationAction, SIGNAL( activated() ), this, SLOT( OnSegmentationSwitch() ) );

  mySegmentationCursorDlg = new VVTK_SegmentationCursorDlg( this, "SegmentationCursorDlg" );
  mySegmentationCursorDlg->SetPlaneAction( myPlaneSegmentationAction );
  mySegmentationCursorDlg->SetSphereAction( mySphereSegmentationAction );
  connect( mySegmentationCursorDlg, SIGNAL( scgClose() ), this, SLOT( OnSegmentationSwitch() ) );

  //SUIT_ToolButton* aSegmentationButton = new SUIT_ToolButton( myPtsToolBar );
  QtxMultiAction* aSegmentationAction = new QtxMultiAction( this );
  aSegmentationAction->insertAction( myPlaneSegmentationAction );
  aSegmentationAction->insertAction( mySphereSegmentationAction );
  myPtsToolBar->addAction( aSegmentationAction );
}

void VVTK_MainWindow1::Initialize(SVTK_RenderWindowInteractor* theInteractor,
				  VVTK_Renderer1* theRenderer)
{
  myRenderer = theRenderer;
  VVTK_MainWindow::Initialize(theInteractor);

  mySegmentationCursorDlg->SetWidgetCtrl( theRenderer->GetWidgetCtrl() );
  mySegmentationCursorDlg->SetInteractor( theInteractor );

  connect( theInteractor, SIGNAL( selectionChanged() ), SLOT( OnSelectionChanged() ) );
  myPickingDlg->SetInteractor( theInteractor );
}

VVTK_MainWindow1::~VVTK_MainWindow1()
{}

//----------------------------------------------------------------------------
VVTK_MainWindow2* VVTK_MainWindow1::CreateMainWindow2(QWidget* theParent, 
						      const char* theName,
						      SUIT_ResourceMgr* theResourceMgr,
						      SUIT_ViewWindow* theViewWindow)
{
  myMainWindow2 = new VVTK_MainWindow2(theParent,
				       theName,
				       theResourceMgr,
				       theViewWindow);
  return myMainWindow2;
}


//----------------------------------------------------------------------------
void VVTK_MainWindow1::OnSelectionModeSwitch(bool theIsSelectionOn)
{
  if ( theIsSelectionOn && !isVisible() )
    return;
  
  Selection_Mode aSelectionMode = SelectionMode();
  if(theIsSelectionOn && aSelectionMode != GaussPointSelection)
    SetSelectionMode(GaussPointSelection);
  else if(!theIsSelectionOn && aSelectionMode == GaussPointSelection)
    SetSelectionMode(ActorSelection);

  if( theIsSelectionOn )
  {
    myPickingDlg->Update();
    myPickingDlg->show();
  }
  else
    myPickingDlg->hide();
}

void VVTK_MainWindow1::OnSelectionChanged()
{
  Selection_Mode aSelectionMode = SelectionMode();
  if(myPickingAction->isChecked() && aSelectionMode != GaussPointSelection)
    myPickingAction->setChecked(false);
  else if(!myPickingAction->isChecked() && aSelectionMode == GaussPointSelection)
    myPickingAction->setChecked(true);
}


//----------------------------------------------------------------------------
VISU_WidgetCtrl* VVTK_MainWindow1::GetWidgetCtrl()
{
  return myRenderer->GetWidgetCtrl();
}

VISU_InsideCursorSettings* VVTK_MainWindow1::GetInsideCursorSettings()
{
  return mySegmentationCursorDlg->GetInsideCursorSettings();
}

VISU_OutsideCursorSettings* VVTK_MainWindow1::GetOutsideCursorSettings()
{
  return mySegmentationCursorDlg->GetOutsideCursorSettings();
}

VISU_PickingSettings* VVTK_MainWindow1::GetPickingSettings()
{
  return myPickingDlg->GetPickingSettings();
}

//----------------------------------------------------------------------------
void VVTK_MainWindow1::SetPlanesSegementation(bool theIsOn)
{
  myPlaneSegmentationAction->setChecked( theIsOn );
  OnSegmentationSwitch(myPlaneSegmentationAction);
}

void VVTK_MainWindow1::SetSphereSegementation(bool theIsOn)
{
  mySphereSegmentationAction->setChecked( theIsOn );
  OnSegmentationSwitch(mySphereSegmentationAction);
}

void VVTK_MainWindow1::OnSegmentationSwitch(QtxAction* theAction)
{
  bool anIsSegmentationOn = myPlaneSegmentationAction->isChecked() ||
    mySphereSegmentationAction->isChecked();

  if( !theAction )
    return;
  
  VISU_WidgetCtrl *aWidgetCtrl = myRenderer->GetWidgetCtrl();
  
  if (anIsSegmentationOn) {
    int anIndex = (theAction == myPlaneSegmentationAction) ? 0 : 1;
    aWidgetCtrl->SetActiveIndex(anIndex);
  }
  aWidgetCtrl->SetEnabled(anIsSegmentationOn);

  if( theAction == myPlaneSegmentationAction && anIsSegmentationOn )
    mySphereSegmentationAction->setChecked( false );
  else if( theAction == mySphereSegmentationAction && anIsSegmentationOn )
    myPlaneSegmentationAction->setChecked( false );

  if( anIsSegmentationOn )
  {
    myMainWindow2->show();
    mySegmentationCursorDlg->SetIsPlaneSegmentation( theAction == myPlaneSegmentationAction );
    mySegmentationCursorDlg->UpdateSegmentation();
    mySegmentationCursorDlg->UpdateInsideGaussPoints();
    mySegmentationCursorDlg->UpdateOutsideGaussPoints();
    mySegmentationCursorDlg->show();
  }
  else
  {
    myMainWindow2->hide();
    mySegmentationCursorDlg->hide();
  }
}

void VVTK_MainWindow1::OnSegmentationSwitch()
{
  QtxAction* anAction = ( QtxAction* )sender();
  OnSegmentationSwitch(anAction);
}


//----------------------------------------------------------------------------
VVTK_MainWindow2::VVTK_MainWindow2(QWidget* theParent, 
				   const char* theName,
				   SUIT_ResourceMgr* theResourceMgr,
				   SUIT_ViewWindow* theViewWindow):
  VVTK_MainWindow(theParent,theName,theResourceMgr,theViewWindow)
{}

VVTK_MainWindow2::~VVTK_MainWindow2()
{}


//----------------------------------------------------------------------------
void VVTK_MainWindow2::Initialize(SVTK_RenderWindowInteractor* theInteractor)
{
  VVTK_MainWindow::Initialize(theInteractor);
}

