//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  SALOME VTKViewer : build VTK viewer into Salome desktop
//  File   : 
//  Author : 
//  Module : SALOME
//  $Header$
//
#ifndef _VVTK_Recorder_Header_File_
#define _VVTK_Recorder_Header_File_

#include <list>
#include <string>
#include <vector>

#include <vtkObject.h>

class vtkRenderWindow;
class vtkCallbackCommand;
class vtkWindowToImageFilter;
class VVTK_ImageWriterMgr;
//
class VVTK_Recorder : public vtkObject 
{
 protected:
  enum State {
    VVTK_Recorder_Unknown=0,
    VVTK_Recorder_Record,
    VVTK_Recorder_Stop
  };
  
 public:
  static VVTK_Recorder *New();
  vtkTypeRevisionMacro(VVTK_Recorder,vtkObject);

  void
  SetRenderWindow(vtkRenderWindow* theRenderWindow);

  vtkRenderWindow* 
  RenderWindow();

  void 
  SetName(const char *theName);

  const char* 
  Name() const;

  void
  SetNbFPS(const double theNbFPS);

  double
  NbFPS() const;

  void
  SetQuality(int theQuality);

  int
  GetQuality() const;

  void
  SetProgressiveMode(bool theProgressiveMode);

  bool
  GetProgressiveMode() const;

  void
  SetUseSkippedFrames(bool theUseSkippedFrames);

  bool
  UseSkippedFrames() const;

  void
  Record();

  void
  Pause();

  void
  Stop();

  int
  State() const;

  int  
  ErrorStatus() const;

  void
  CheckExistAVIMaker();

protected :
  VVTK_Recorder();

  ~VVTK_Recorder();

  void
  DoRecord();

  void
  MakeFileAVI();

  void
  AddSkippedFrames();

  void
  PreWrite();

  static
  void
  ProcessEvents(vtkObject* theObject, 
		unsigned long theEvent,
		void* theClientData, 
		void* theCallData);

protected :
  int myState;
  int myPaused;
  int myErrorStatus;

  float myPriority;
  double myTimeStart;

  int myFrameIndex;
  int myNbWrittenFrames;

  double myNbFPS;
  int myQuality;
  bool myProgressiveMode;

  typedef std::vector<int> TFrameIndexes;
  TFrameIndexes myFrameIndexes;
  bool myUseSkippedFrames;

  std::string myName;
  std::string myNameAVIMaker;

  vtkCallbackCommand *myCommand;
  vtkRenderWindow *myRenderWindow;
  vtkWindowToImageFilter *myFilter;
  VVTK_ImageWriterMgr *myWriterMgr;


private:
  VVTK_Recorder(const VVTK_Recorder&);  //Not implemented
  void operator=(const VVTK_Recorder&); //Not implemented
};
#endif
