//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
#include "VVTK_ViewModel.h"
#include "VISU_ActorFactory.h"
#include "VVTK_ViewWindow.h"

#include "VTKViewer_Algorithm.h"
#include "SVTK_Functor.h"
#include "VISU_ActorBase.h"
#include "SVTK_View.h"
#include "SVTK_Prs.h"

#include <SUIT_ViewManager.h>

#include <vtkActorCollection.h>
#include <vtkRenderer.h>

//---------------------------------------------------------------
VVTK_Viewer::VVTK_Viewer()
{
}

//---------------------------------------------------------------
VVTK_Viewer::~VVTK_Viewer() 
{
}

//---------------------------------------------------------------
SUIT_ViewWindow* VVTK_Viewer::createView( SUIT_Desktop* theDesktop )
{
  TViewWindow* aViewWindow = new TViewWindow (theDesktop);
  aViewWindow->Initialize(this);

  aViewWindow->setBackgroundColor( backgroundColor() );
  aViewWindow->SetTrihedronSize( trihedronSize() );
  aViewWindow->SetProjectionMode( projectionMode() );
  aViewWindow->SetInteractionStyle( interactionStyle() );
  aViewWindow->SetIncrementalSpeed( incrementalSpeed(), incrementalSpeedMode() );
  aViewWindow->SetSpacemouseButtons( spacemouseBtn(1), spacemouseBtn(2), spacemouseBtn(3) );

  return aViewWindow;
}

//---------------------------------------------------------------
void VVTK_Viewer::Display(const SALOME_VTKPrs* thePrs)
{
  // try do downcast object
  if(const SVTK_Prs* aPrs = dynamic_cast<const SVTK_Prs*>(thePrs)){
    if(aPrs->IsNull())
      return;
    if(vtkActorCollection* aCollection = aPrs->GetObjects()){
      aCollection->InitTraversal();
      while(VISU_ActorBase* anActor = dynamic_cast<VISU_ActorBase*>(aCollection->GetNextActor())){
	if(!anActor->GetFactory()->GetActiveState())
	  continue;
	QVector<SUIT_ViewWindow*> aViews = myViewManager->getViews();
	for(int i = 0, iEnd = aViews.size(); i < iEnd; i++){
	  if(SVTK_ViewWindow* aViewWindow = dynamic_cast<SVTK_ViewWindow*>(aViews.at(i))){
	    if(SVTK_View* aView = aViewWindow->getView()){
	      aView->Display(anActor, false);
	    }
	  }
	}
      }
    }
  }
}

//---------------------------------------------------------------
namespace VVTK
{
  struct TIsOneActorVisibleAction
  {
    bool& myResult;
    TIsOneActorVisibleAction(bool& theResult): 
      myResult(theResult)
    {
      myResult = false;
    }
    void
    operator()(SALOME_Actor* theActor)
    {
      if(!myResult)
	myResult = theActor->GetVisibility();
    }
  };
}

//---------------------------------------------------------------
bool VVTK_Viewer::isVisible( const Handle(SALOME_InteractiveObject)& theIO )
{
  QVector<SUIT_ViewWindow*> aViews = myViewManager->getViews();
  for(int i = 0, iEnd = aViews.size(); i < iEnd; i++)
    if(SVTK_ViewWindow* aViewWindow = dynamic_cast<SVTK_ViewWindow*>(aViews.at(i))){
      bool aResult;
      VVTK::TIsOneActorVisibleAction anAction(aResult);
      VTK::ActorCollectionCopy aCopy(aViewWindow->getRenderer()->GetActors());
      SVTK::ForEachIf<SALOME_Actor>(aCopy.GetActors(),
				    SVTK::TIsSameIObject<SALOME_Actor>(theIO),
				    anAction);
      return anAction.myResult;
    }
  
  return false;
}
