# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class GuideTube2D(XNamedObject):
    __init__xattributes__ = [
        XAttribute("external_radius", xtype=XFloat(open_min=0.0)),
        XAttribute("internal_radius", xtype=XFloat(min=0.0), default_value=0.0),
        ]
    def setExternalRadius(self, value):
        er = self.external_radius
        try:
            ir = self.internal_radius
        except AttributeError:
            return
        XFloat(open_min=ir).testValue(er)
        return
    def setInternalRadius(self, value):
        er = self.external_radius
        ir = self.internal_radius
        XFloat(open_max=er).testValue(ir)
        return
    pass

class GuideTube2DTestCase(unittest.TestCase):
    def test(self):
        g = GuideTube2D(3.0, 2.0)
        self.failUnlessRaises(XValueError, g.setInternalRadius, 4.0)
        self.failUnlessRaises(XValueError, g.setExternalRadius, 1.0)
        self.failUnlessEqual(g.external_radius, 3.0)
        self.failUnlessEqual(g.internal_radius, 2.0)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
