# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class A(XObject):
    __init__xattributes__ = [
        XAttribute('l', xtype=XList(sequence=XInt())),
        ]
    def add(self, item):
        self.l.append(item)
        return
    def add_ok(self, item):
        self.l.append(item)
        # To check l : set the attribute ...
        self.l = self.l
        return
    pass

class ATestCase(unittest.TestCase):
    def test1(self):
        a = A([1, 2, 3])
        a.add('totot')   # WORKS AND IT SHOULD NOT ...
        return
    def test2(self):
        a = A([1, 2, 3])
        self.failUnlessRaises(XValueError, a.add_ok, 'totot')
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
