# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XMulTypesTestCase(unittest.TestCase):
    def test(self):
        self.failUnlessRaises(XValueError, XMulTypes, "toto")
        #
        x = XMulTypes(XInt(min=3), XFloat(max=-12))
        self.failUnlessRaises(XValueError, x, 0)
        self.failUnlessEqual(x("14"), 14)
        self.failUnlessEqual(x("-44.56"), -44.56)
        #
        x = XMulTypes(XInt(), XList(sequence=XInt()))
        self.failUnlessRaises(XValueError, x, "toto")
        self.failUnlessRaises(XValueError, x, ["toto"])
        self.failUnlessEqual(x("1"), 1)
        self.failUnlessEqual(x([1, 2, 3]), [1, 2, 3])
        #
        x = XMulTypes(XInt(), XList(sequence=[XString(),XInt()]))
        self.failUnlessEqual(x(1), 1)
        self.failUnlessEqual(x(["a", "1", "b", "2"]), ["a", 1, "b", 2])
        self.failUnlessRaises(XValueError, x, "toto")
        self.failUnlessRaises(XValueError, x, ["a", "1", "b"])
        self.failUnlessRaises(XValueError, x, ["a", "1", "b", "toto"])
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
