# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

class XInterceptorBase(object):
    
    def __init__(self, name, real_attribute):
        self.name = name
        self.__name__ = name
        self.real_attribute = real_attribute
        self.__doc__ = real_attribute.__doc__
        return
    
    def __get__(self, obj, typ):
        self.obj = obj
        self.typ = typ
        return self
    
    pass

class XInterceptor(XInterceptorBase):
    
    def __call__(self, *args, **kwargs):
        name, real_attribute = self.name, self.real_attribute
        obj, typ = self.obj, self.typ
        if obj is None:
            obj = args[0]
            args = tuple(args[1:])
            pass
        len_args = len(args)
        
        init_args, init_kwargs = tuple(args), dict(kwargs)
        
        if hasattr(obj, "__corba__component__"):
            component = getattr(obj, "__corba__component__")
        else:
            component = None
            pass
        
        xmethod = None
        for x in typ.__object__xmethods__:
            if getattr(x, '__name') != name: continue
            xmethod = x
            break
        
        # E.A. : The xmethod can be declared in a base class !!
        
        if xmethod is None:
            from xutilities import getMRO
            from xdata import XObject
            l = getMRO(typ, XObject)
            l = l[1:]
            for cls in l:
                found = 0
                for x in cls.__object__xmethods__:
                    if getattr(x, '__name') != name: continue
                    xmethod = x
                    found = 1
                    break
                if found:
                    break
                pass
            pass
            
##        if component:
##            if xmethod is None:
##                from xutilities import value2text
##                msg  = ""
##                msg += "\n"
##                msg += "\n"
##                msg += "%s is not a service of your instance of\n"%(value2text(name))
##                msg += "\n"
##                nn = "%s.%s"%(typ.__module__, typ.__name__)
##                msg += "%s:\n"%(nn)
##                msg += "%s ...\n"%(obj)
##                msg += "\n"
##                msg += "services are : %s\n"%(value2text([x.name for x in typ.__object__xmethods__]))
##                msg += "and those associated to the xattributes (get and set) ...\n"
##                # from xexceptions import XAttributeError
##                # raise XAttributeError(msg)
##            pass
        
        if xmethod:
            # --
            # Put the args items in kwargs
            for i in range(len_args):
                # --
                # Get the attribute key corresponding to the i-th arg
                try:
                    key = xmethod.in_xattributes[i].name
                except IndexError:
                    # --
                    # An IndexError indicates that too much args are given for this __init__
                    # compared to the length of __init__xattributes__
                    msg  = "\n\n"
                    msg += "The number of arguments given in args does not fit\n"
                    msg += "the good number in %s which is %s ...\n"%(name, len(xmethod.in_xattributes))
                    from xexceptions import XAttributeError
                    raise XAttributeError(msg)
                # --
                # Check that key is given only once
                if kwargs.has_key(key):
                    # --
                    # Means that an attribute is given more than once
                    from xutilities import value2text
                    msg = "got multiple values for attribute %s"%(value2text(key))
                    from xexceptions import XAttributeError
                    raise XAttributeError(msg)
                # --
                # Add the key with value args[i] in kwargs
                kwargs[key] = args[i]
                pass
            # --
            # Nullify args
            
            args = ()
            
            # --
            # 1. Check the user kwargs items with the corresponding xtype
            #    for corba and __python__text__
            # 2. Construct a values list for the attributes to be send on
            #    corba bus
            
            values = []
            
            xattrs = xmethod.in_xattributes
            if xattrs is None:
                xattrs = []
                pass
            
            for i in range(len(xattrs)):
                xattr = xattrs[i]
                key = xattr.name
                if kwargs.has_key(key):
                    # --
                    # key is in user_kwargs
                    xtype = getattr(xattr, '__xtype')
                    val = kwargs[key]
                    val = xtype(val)
                    kwargs[key] = val
                else:
                    # --
                    # key is not in user_kwargs
                    # It must have a default_value
                    if not xattr.hasDefaultValue():
                        # --
                        # mandatory attribute not setted
                        msg  = "\n\n"
                        from xutilities import value2text
                        msg += "Mandatory attribute %s not set\n"%(value2text(key))
                        from xexceptions import XAttributeError
                        raise XAttributeError(msg)
                    val = getattr(xattr, '__default_value')
                    from copy import copy
                    try:
                        val = copy(val)
                    except:
                        pass
                    pass
                if component:
                    from xutilities import message
                    message("key, python_value:", key, val)
                    from xsalome import python2corba
                    val = python2corba(val, component, getattr(xattr, '__xtype'), 0)
                    from xutilities import message
                    message("key, corba_value:", key, val)
                    pass
                values.append(val)
                pass
            pass
        
        if component and xmethod:
            meth = getattr(obj.__corba__object__, name)
            try:
                corba_object = meth(*values)
            except Exception, e:
                from xsalome import corba2python
                e = corba2python(e)
                raise e
            from xsalome import corba2python
            result = corba2python(corba_object)
        else:
            # --
            # 11/01/2007 : It seems that with python 2.2.x, when
            # pickling an object and reloading it the attribute
            # __xcontext__ disappeared ... so try ... except ...
            # --
            try:
                xcontext = obj.__xcontext__
            except AttributeError:
                xcontext = None
                pass
            # --
            obj.__xcontext__ = name
            result = real_attribute(obj, *args, **kwargs)
            obj.__xcontext__ = xcontext
            if xmethod:
                xtype = getattr(xmethod, '__out_xtype')
                xattrs = getattr(xmethod, '__out_xattributes')
                if ( xtype is None ) and ( xattrs is None ):
                    from xtypes import xnone_empty
                    result = xnone_empty(result)
                    pass
                if xtype:
                    result = xtype(result)
                    pass
                if xattrs:
                    if len(xattrs) == 1:
                        xa = xattrs[0]
                        xtype = xa.xtype
                        result = xtype(result)
                    else:
                        result_tmp = []
                        for i in range(len(xattrs)):
                            xa = xattrs[i]
                            res = result[i]
                            res = xa.xtype(res)
                            result_tmp.append(res)
                            pass
                        result = tuple(result_tmp)
                        pass
                    pass
                pass
            pass
        
##        if not hasattr(typ, '__xsomething__'):
##            from xcontext import getInterface
##            interface = getInterface()
##            if ( interface in ("gui", "tui", ) ) :
##                from xutilities import message
##                message(typ, name)
##                from xdatagui import getMainWindow
##                mw = getMainWindow()
##                if mw:
##                    from qt import PYSIGNAL
##                    from xutilities import message
##                    message('sending (PYSIGNAL("old_object_modified")')
##                    mw.emit(PYSIGNAL("old_object_modified"), (obj, ))
##                    pass
##                pass
##            pass
        
        return result
    
    pass

class InitXInterceptor(XInterceptorBase):
    
    def __call__(self, *args, **kwargs):
        # --
        #
        
        name, real_attribute = self.name, self.real_attribute
        obj, typ = self.obj, self.typ
        self.obj, self.typ = None, None
        if obj is None:
            obj = args[0]
            args = args[1:]
            pass
        len_args = len(args)
        
        # --
        #
        
        if hasattr(obj, "__corba__component__"):
            component = getattr(obj, "__corba__component__")
            from xutilities import message
            message('cls: ', typ, cls="InitXInterceptor")
        else:
            component = None
            pass
        
        # --
        # get the __init__ xattributes keys
        
        inames = typ.getAllInitXAttributesNames()
        
        # --
        # If len(inames) == 0: run the user __init__ directly
        # By this way, developpers can transform their code more
        # easily in xdata language.
        
        if len(inames) == 0:
            if component:
                try:
                    meth = getattr(component, "new%s_no_superv"%(typ.__name__))
                except AttributeError:
                    meth = getattr(component, "new%s%s_no_superv"%(typ.__module__, typ.__name__))
                    pass
                message("calling new%s on %s"%(typ.__name__, component))
                try:
                    corba_object = meth()
                except Exception, e:
                    from xsalome import corba2python
                    e = corba2python(e)
                    raise e
                obj.__corba__object__ = corba_object
                from xsalome import register
                register(obj, corba_object)
            else:
                xcontext = obj.__xcontext__
                obj.__xcontext__ = name
                self.setValuesOfObjectXAttributesWithDefaultValue(typ, obj, component)
                result = real_attribute(obj, *args, **kwargs)
                obj.__xcontext__ = xcontext
                pass
            return
        
        # --
        # Check that the keys in kwargs are known
        
        for key in kwargs.keys():
            if key not in inames:
                msg  = '\n\n'
                from xutilities import value2text
                msg += "Unknown attribute : %s, "%(value2text(key))
                msg += "not in %s.\n"%(value2text(inames))
                from xexceptions import XAttributeError
                raise XAttributeError(msg)
            pass
        
        # --
        # Check that args satisfy the __init__argslen__ condition
        
        iargslen = getattr(typ, "____init__argslen__")
        if iargslen > -1:
            if len_args > iargslen:
                names = [inames[i] for i in range(iargslen, len(inames))]
                msg  = "\n\n"
                from xutilities import value2text
                msg += "The attributes in %s must be given explicitely.\n"%(value2text(names))
                from xexceptions import XAttributeError
                raise XAttributeError(msg)
            pass
        
        # --
        # get the __init__ xattributes
        
        ixattrs = typ.getAllInitXAttributes()
        
        # --
        # Particuliar case when there is only one xattribute and
        # the corresponding xtype is a XList ... For instance, it's
        # the case of XInstance where the only xattribute is "classes"
        # In that case, we want accept XInstance(A, B, C) and transform
        # it into XInstance([A, B, C])
        # --
        # We check only for len_args > 1 since the case len_args == 1
        # is directly treated in the xtype since in that case val = A is
        # transformed into val = [A] in the xtype
        # 
        
        if len_args > 1:
            if len(ixattrs) == 1:
                xattr = ixattrs[0]
                xtype = getattr(xattr, "__xtype")
                from xtypes import XList
                if isinstance(xtype, XList):
                    args = (list(args), )
                    len_args = len(args)
                    pass
                pass
            pass
        
        # --
        # Put the args items in kwargs
        
        for i in range(len_args):
            # --
            # Get the attribute key corresponding to the i-th arg
            try:
                key = inames[i]
            except IndexError:
                # --
                # An IndexError indicates that too much args are given for this __init__
                # compared to the length of __init__xattributes__
                msg  = "\n\n"
                msg += "The number of arguments given in args does not fit\n"
                msg += "the good number in __init__ which is %s ...\n"%(len(ixattrs))
                from xexceptions import XAttributeError
                raise XAttributeError(msg)
            # --
            # Check that key is given only once
            if kwargs.has_key(key):
                # --
                # Means that an attribute is given more than once
                from xutilities import value2text
                msg = "got multiple values for attribute %s"%(value2text(key))
                from xexceptions import XAttributeError
                raise XAttributeError(msg)
            # --
            # Add the key with value args[i] in kwargs
            kwargs[key] = args[i]
            pass
        
        # --
        # Nullify args
        
        args = ()
        
        # --
        # 1. Check the user kwargs items with the corresponding xtype
        #    for corba and __python__text__
        # 2. Construct a user_kwargs to be send in user __init__ and
        #    returned in __init__ to construct the __python__text__
        # 2. Add the default value to kwargs for the non-setted items
        # 3. Construct a values list for the attributes to be setted
        #    in a predictive order which is not the case for a dict
        
        user_kwargs = {}
        values = []
        
        for i in range(len(ixattrs)):
            key = inames[i]
            xattr = ixattrs[i]
            if kwargs.has_key(key):
                # --
                # key is in user_kwargs
                xtype = getattr(xattr, '__xtype')
                val = kwargs[key]
                if hasattr(val, "_narrow"):
                    from xsalome import corba2python
                    val = corba2python(val)
                    pass
                val = xtype(val)
                user_kwargs[key] = val
            else:
                # --
                # key is not in user_kwargs
                # It must have a default_value
                if not xattr.hasDefaultValue():
                    # --
                    # mandatory attribute not setted
                    msg  = "\n\n"
                    from xutilities import value2text
                    msg += "Mandatory attribute %s not set\n"%(value2text(key))
                    from xexceptions import XAttributeError
                    raise XAttributeError(msg)
                val = getattr(xattr, '__default_value')
                # Copy the default_value 'cause some dev. use
                # mutable ones
                from copy import copy
                try:
                    val = copy(val)
                except:
                    pass
                # For __xnamedobject__, replace None by
                # the name if already defined
                # obj.__instance__name__ elsewhere
                if typ.__xnamedobject__:
                    if xattr is typ.__name__xattribute__:
                        if hasattr(obj, "name"):
                            val = obj.name
                        else:
                            val = obj.__instance__name__
                            pass
                        pass
                    pass
                pass
            if component:
                from xutilities import message
                message("key, python_value:", key, val, cls="InitXInterceptor")
                from xsalome import python2corba
                val = python2corba(val, component, getattr(xattr, '__xtype'))
                message("key, corba_value:", key, val, cls="InitXInterceptor")
                pass
            values.append(val)
            pass
        
        # --
        #
        
        if component:
            try:
                meth = getattr(component, "new%s_no_superv"%(typ.__name__))
            except AttributeError:
                meth = getattr(component, "new%s%s_no_superv"%(typ.__module__, typ.__name__))
                pass
            message('calling component.new%s(*%s)'%(typ.__name__, values))
            try:
                corba_object = meth(*values)
            except Exception, e:
                from xsalome import corba2python
                e = corba2python(e)
                raise e
            message('corba_object = ', corba_object)
            obj.__corba__object__ = corba_object
            from xsalome import register
            register(obj, corba_object)
            message()
            message()
        else:
            xcontext = obj.__xcontext__
            obj.__xcontext__ = name
            self.setValuesOfObjectXAttributesWithDefaultValue(typ, obj, component)
            for i in range(len(inames)):
                key, val = inames[i], values[i]
                from xutilities import name2capname
                accessor = getattr(typ, "set%s"%(name2capname(key)))
                # --
                # Use the _check flag 'cause val has already been checked
                # here the the user vals and in xtype for the default values
                # I think it's the only place where I can use it ...
                accessor(obj, val, _check=0)
                pass
            result = real_attribute(obj, *args, **user_kwargs)
            obj.__xcontext__ = xcontext
            pass
        
        # --
        #
        
        return user_kwargs
    
    def setValuesOfObjectXAttributesWithDefaultValue(self, typ, obj, component):
        if component: return
        oxattrs = typ.__oxattrs__
        if not oxattrs : return
        xcontext = obj.__xcontext__
        obj.__xcontext__ = "__init__"
        for x in oxattrs:
            if not x.hasDefaultValue(): continue
            key, val = getattr(x, '__name'), getattr(x, '__default_value')
            from xutilities import name2capname
            accessor = getattr(typ, "set%s"%(name2capname(key)))
            accessor(obj, val, _check=0)
            pass
        obj.__xcontext__ = xcontext
        return
    
    pass
